package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.{
  ValueAsString,
  FeatureName
}
import scala.jdk.CollectionConverters.*
final case class FeatureValue(
    featureName: FeatureName,
    valueAsString: ValueAsString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue = {
    import FeatureValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue
      .builder()
      .featureName(FeatureName.unwrap(featureName): java.lang.String)
      .valueAsString(ValueAsString.unwrap(valueAsString): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue
      .wrap(buildAwsValue())
}
object FeatureValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue =
      zio.aws.sagemakerfeaturestoreruntime.model
        .FeatureValue(featureName, valueAsString)
    def featureName: FeatureName
    def valueAsString: ValueAsString
    def getFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(featureName)
    def getValueAsString: ZIO[Any, Nothing, ValueAsString] =
      ZIO.succeed(valueAsString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly {
    override val featureName: FeatureName =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .FeatureName(impl.featureName())
    override val valueAsString: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.valueAsString())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue
  ): zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly =
    new Wrapper(impl)
}
