package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.{
  FeatureName,
  ValueAsString,
  FeatureGroupName
}
import scala.jdk.CollectionConverters.*
final case class BatchGetRecordIdentifier(
    featureGroupName: FeatureGroupName,
    recordIdentifiersValueAsString: Iterable[ValueAsString],
    featureNames: Option[Iterable[FeatureName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier = {
    import BatchGetRecordIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier
      .builder()
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .recordIdentifiersValueAsString(recordIdentifiersValueAsString.map {
        item =>
          ValueAsString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        featureNames.map(value =>
          value.map { item =>
            FeatureName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.featureNames)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier
      .wrap(buildAwsValue())
}
object BatchGetRecordIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier =
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier(
        featureGroupName,
        recordIdentifiersValueAsString,
        featureNames.map(value => value)
      )
    def featureGroupName: FeatureGroupName
    def recordIdentifiersValueAsString: List[ValueAsString]
    def featureNames: Option[List[FeatureName]]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getRecordIdentifiersValueAsString
        : ZIO[Any, Nothing, List[ValueAsString]] =
      ZIO.succeed(recordIdentifiersValueAsString)
    def getFeatureNames: ZIO[Any, AwsError, List[FeatureName]] =
      AwsError.unwrapOptionField("featureNames", featureNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.ReadOnly {
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val recordIdentifiersValueAsString: List[ValueAsString] = impl
      .recordIdentifiersValueAsString()
      .asScala
      .map { item =>
        zio.aws.sagemakerfeaturestoreruntime.model.primitives
          .ValueAsString(item)
      }
      .toList
    override val featureNames: Option[List[FeatureName]] = scala
      .Option(impl.featureNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakerfeaturestoreruntime.model.primitives
            .FeatureName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier
  ): zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.ReadOnly =
    new Wrapper(impl)
}
