package zio.aws.sagemakerfeaturestoreruntime
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.{
  GetRecordResponse,
  GetRecordRequest,
  DeleteRecordRequest,
  BatchGetRecordResponse,
  BatchGetRecordRequest,
  PutRecordRequest,
  PutRecordResponse,
  DeleteRecordResponse
}
import zio.aws.core.config.AwsConfig
import zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.{
  SageMakerFeatureStoreRuntimeAsyncClientBuilder,
  SageMakerFeatureStoreRuntimeAsyncClient
}
import scala.jdk.CollectionConverters.*
trait SageMakerFeatureStoreRuntime
    extends AspectSupport[SageMakerFeatureStoreRuntime] {
  val api: SageMakerFeatureStoreRuntimeAsyncClient
  def batchGetRecord(
      request: zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest
  ): IO[
    AwsError,
    zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse.ReadOnly
  ]
  def deleteRecord(
      request: zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
  ): IO[AwsError, Unit]
  def getRecord(
      request: zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest
  ): IO[AwsError, ReadOnly]
  def putRecord(
      request: zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest
  ): IO[AwsError, Unit]
}
object SageMakerFeatureStoreRuntime {
  val live
      : ZLayer[AwsConfig, java.lang.Throwable, SageMakerFeatureStoreRuntime] =
    customized(identity)
  def customized(
      customization: SageMakerFeatureStoreRuntimeAsyncClientBuilder => SageMakerFeatureStoreRuntimeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SageMakerFeatureStoreRuntime] =
    managed(customization).toLayer
  def managed(
      customization: SageMakerFeatureStoreRuntimeAsyncClientBuilder => SageMakerFeatureStoreRuntimeAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, SageMakerFeatureStoreRuntime] =
    for (
      awsConfig <- ZManaged.service[AwsConfig];
      executor <- ZIO.executor.toManaged;
      builder = SageMakerFeatureStoreRuntimeAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig
        .configure[
          SageMakerFeatureStoreRuntimeAsyncClient,
          SageMakerFeatureStoreRuntimeAsyncClientBuilder
        ](builder)
        .toManaged;
      b1 <- awsConfig
        .configureHttpClient[
          SageMakerFeatureStoreRuntimeAsyncClient,
          SageMakerFeatureStoreRuntimeAsyncClientBuilder
        ](
          b0,
          zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
        )
        .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
    )
      yield new SageMakerFeatureStoreRuntimeImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class SageMakerFeatureStoreRuntimeImpl[R](
      override val api: SageMakerFeatureStoreRuntimeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SageMakerFeatureStoreRuntime
      with AwsServiceBase[R] {
    override val serviceName: String = "SageMakerFeatureStoreRuntime"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SageMakerFeatureStoreRuntimeImpl[R1] =
      new SageMakerFeatureStoreRuntimeImpl(api, newAspect, r)
    def batchGetRecord(
        request: zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest
    ): IO[
      AwsError,
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse.ReadOnly
    ] = asyncRequestResponse[BatchGetRecordRequest, BatchGetRecordResponse](
      "batchGetRecord",
      api.batchGetRecord
    )(request.buildAwsValue())
      .map(
        zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse.wrap
      )
      .provideEnvironment(r)
    def deleteRecord(
        request: zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteRecordRequest, DeleteRecordResponse](
        "deleteRecord",
        api.deleteRecord
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getRecord(
        request: zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetRecordRequest, GetRecordResponse](
        "getRecord",
        api.getRecord
      )(request.buildAwsValue())
        .map(zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse.wrap)
        .provideEnvironment(r)
    def putRecord(
        request: zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutRecordRequest, PutRecordResponse](
        "putRecord",
        api.putRecord
      )(request.buildAwsValue()).unit.provideEnvironment(r)
  }
  def batchGetRecord(
      request: zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest
  ): ZIO[
    zio.aws.sagemakerfeaturestoreruntime.SageMakerFeatureStoreRuntime,
    AwsError,
    zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetRecord(request))
  def deleteRecord(
      request: zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
  ): ZIO[
    zio.aws.sagemakerfeaturestoreruntime.SageMakerFeatureStoreRuntime,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.deleteRecord(request))
  def getRecord(
      request: zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest
  ): ZIO[
    zio.aws.sagemakerfeaturestoreruntime.SageMakerFeatureStoreRuntime,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecord(request))
  def putRecord(
      request: zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest
  ): ZIO[
    zio.aws.sagemakerfeaturestoreruntime.SageMakerFeatureStoreRuntime,
    AwsError,
    Unit
  ] = ZIO.serviceWithZIO(_.putRecord(request))
}
