package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.{
  Message,
  ValueAsString
}
import scala.jdk.CollectionConverters.*
final case class BatchGetRecordError(
    featureGroupName: ValueAsString,
    recordIdentifierValueAsString: ValueAsString,
    errorCode: ValueAsString,
    errorMessage: Message
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError = {
    import BatchGetRecordError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError
      .builder()
      .featureGroupName(
        ValueAsString.unwrap(featureGroupName): java.lang.String
      )
      .recordIdentifierValueAsString(
        ValueAsString.unwrap(recordIdentifierValueAsString): java.lang.String
      )
      .errorCode(ValueAsString.unwrap(errorCode): java.lang.String)
      .errorMessage(Message.unwrap(errorMessage): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError
      .wrap(buildAwsValue())
}
object BatchGetRecordError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError =
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError(
        featureGroupName,
        recordIdentifierValueAsString,
        errorCode,
        errorMessage
      )
    def featureGroupName: ValueAsString
    def recordIdentifierValueAsString: ValueAsString
    def errorCode: ValueAsString
    def errorMessage: Message
    def getFeatureGroupName: ZIO[Any, Nothing, ValueAsString] =
      ZIO.succeed(featureGroupName)
    def getRecordIdentifierValueAsString: ZIO[Any, Nothing, ValueAsString] =
      ZIO.succeed(recordIdentifierValueAsString)
    def getErrorCode: ZIO[Any, Nothing, ValueAsString] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, Message] = ZIO.succeed(errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError.ReadOnly {
    override val featureGroupName: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.featureGroupName())
    override val recordIdentifierValueAsString: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.recordIdentifierValueAsString())
    override val errorCode: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.errorCode())
    override val errorMessage: Message =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .Message(impl.errorMessage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError
  ): zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError.ReadOnly =
    new Wrapper(impl)
}
