package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.ValueAsString
import scala.jdk.CollectionConverters.*
final case class BatchGetRecordResultDetail(
    featureGroupName: ValueAsString,
    recordIdentifierValueAsString: ValueAsString,
    record: Iterable[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail = {
    import BatchGetRecordResultDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail
      .builder()
      .featureGroupName(
        ValueAsString.unwrap(featureGroupName): java.lang.String
      )
      .recordIdentifierValueAsString(
        ValueAsString.unwrap(recordIdentifierValueAsString): java.lang.String
      )
      .record(record.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail
      .wrap(buildAwsValue())
}
object BatchGetRecordResultDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail =
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail(
        featureGroupName,
        recordIdentifierValueAsString,
        record.map { item =>
          item.asEditable
        }
      )
    def featureGroupName: ValueAsString
    def recordIdentifierValueAsString: ValueAsString
    def record
        : List[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly]
    def getFeatureGroupName: ZIO[Any, Nothing, ValueAsString] =
      ZIO.succeed(featureGroupName)
    def getRecordIdentifierValueAsString: ZIO[Any, Nothing, ValueAsString] =
      ZIO.succeed(recordIdentifierValueAsString)
    def getRecord: ZIO[Any, Nothing, List[
      zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly
    ]] = ZIO.succeed(record)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail.ReadOnly {
    override val featureGroupName: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.featureGroupName())
    override val recordIdentifierValueAsString: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.recordIdentifierValueAsString())
    override val record: List[
      zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly
    ] = impl
      .record()
      .asScala
      .map { item =>
        zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail
  ): zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail.ReadOnly =
    new Wrapper(impl)
}
