package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetRecordResponse(
    records: Iterable[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail
    ],
    errors: Iterable[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError
    ],
    unprocessedIdentifiers: Iterable[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse = {
    import BatchGetRecordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse
      .builder()
      .records(records.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .unprocessedIdentifiers(unprocessedIdentifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse
      .wrap(buildAwsValue())
}
object BatchGetRecordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse =
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse(
        records.map { item =>
          item.asEditable
        },
        errors.map { item =>
          item.asEditable
        },
        unprocessedIdentifiers.map { item =>
          item.asEditable
        }
      )
    def records: List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail.ReadOnly
    ]
    def errors: List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError.ReadOnly
    ]
    def unprocessedIdentifiers: List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.ReadOnly
    ]
    def getRecords: ZIO[Any, Nothing, List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail.ReadOnly
    ]] = ZIO.succeed(records)
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError.ReadOnly
    ]] = ZIO.succeed(errors)
    def getUnprocessedIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.ReadOnly
    ]] = ZIO.succeed(unprocessedIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse.ReadOnly {
    override val records: List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail.ReadOnly
    ] = impl
      .records()
      .asScala
      .map { item =>
        zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail
          .wrap(item)
      }
      .toList
    override val errors: List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError.ReadOnly
    ] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordError
          .wrap(item)
      }
      .toList
    override val unprocessedIdentifiers: List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.ReadOnly
    ] = impl
      .unprocessedIdentifiers()
      .asScala
      .map { item =>
        zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse
  ): zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse.ReadOnly =
    new Wrapper(impl)
}
