package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.FeatureGroupName
import scala.jdk.CollectionConverters._
final case class PutRecordRequest(
    featureGroupName: FeatureGroupName,
    record: Iterable[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest = {
    import PutRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest
      .builder()
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .record(record.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest
      .wrap(buildAwsValue())
}
object PutRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest =
      zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest(
        featureGroupName,
        record.map { item =>
          item.asEditable
        }
      )
    def featureGroupName: FeatureGroupName
    def record
        : List[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getRecord: ZIO[Any, Nothing, List[
      zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly
    ]] = ZIO.succeed(record)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest.ReadOnly {
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val record: List[
      zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly
    ] = impl
      .record()
      .asScala
      .map { item =>
        zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest
  ): zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest.ReadOnly =
    new Wrapper(impl)
}
