package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetRecordRequest(
    identifiers: Iterable[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier
    ],
    expirationTimeResponse: Optional[
      zio.aws.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest = {
    import BatchGetRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest
      .builder()
      .identifiers(identifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(expirationTimeResponse.map(value => value.unwrap))(
        _.expirationTimeResponse
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest
      .wrap(buildAwsValue())
}
object BatchGetRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest =
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest(
        identifiers.map { item =>
          item.asEditable
        },
        expirationTimeResponse.map(value => value)
      )
    def identifiers: List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.ReadOnly
    ]
    def expirationTimeResponse: Optional[
      zio.aws.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse
    ]
    def getIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.ReadOnly
    ]] = ZIO.succeed(identifiers)
    def getExpirationTimeResponse: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse
    ] = AwsError.unwrapOptionField(
      "expirationTimeResponse",
      expirationTimeResponse
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest.ReadOnly {
    override val identifiers: List[
      zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.ReadOnly
    ] = impl
      .identifiers()
      .asScala
      .map { item =>
        zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier
          .wrap(item)
      }
      .toList
    override val expirationTimeResponse: Optional[
      zio.aws.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationTimeResponse())
      .map(value =>
        zio.aws.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest
  ): zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordRequest.ReadOnly =
    new Wrapper(impl)
}
