package zio.aws.sagemakerfeaturestoreruntime.model
import scala.jdk.CollectionConverters._
sealed trait TargetStore {
  def unwrap
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore
}
object TargetStore {
  def wrap(
      value: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore
  ): zio.aws.sagemakerfeaturestoreruntime.model.TargetStore = value match {
    case software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore.ONLINE_STORE =>
      val r = OnlineStore
      r
    case software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore.OFFLINE_STORE =>
      val r = OfflineStore
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemakerfeaturestoreruntime.model.TargetStore {
    override def unwrap
        : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore =
      software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore.UNKNOWN_TO_SDK_VERSION
  }
  case object OnlineStore
      extends zio.aws.sagemakerfeaturestoreruntime.model.TargetStore {
    override def unwrap
        : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore =
      software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore.ONLINE_STORE
  }
  case object OfflineStore
      extends zio.aws.sagemakerfeaturestoreruntime.model.TargetStore {
    override def unwrap
        : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore =
      software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TargetStore.OFFLINE_STORE
  }
}
