package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.{
  ValueAsString,
  FeatureGroupNameOrArn
}
import scala.jdk.CollectionConverters._
final case class DeleteRecordRequest(
    featureGroupName: FeatureGroupNameOrArn,
    recordIdentifierValueAsString: ValueAsString,
    eventTime: ValueAsString,
    targetStores: Optional[
      Iterable[zio.aws.sagemakerfeaturestoreruntime.model.TargetStore]
    ] = Optional.Absent,
    deletionMode: Optional[
      zio.aws.sagemakerfeaturestoreruntime.model.DeletionMode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest = {
    import DeleteRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
      .builder()
      .featureGroupName(
        FeatureGroupNameOrArn.unwrap(featureGroupName): java.lang.String
      )
      .recordIdentifierValueAsString(
        ValueAsString.unwrap(recordIdentifierValueAsString): java.lang.String
      )
      .eventTime(ValueAsString.unwrap(eventTime): java.lang.String)
      .optionallyWith(
        targetStores.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.targetStoresWithStrings)
      .optionallyWith(deletionMode.map(value => value.unwrap))(_.deletionMode)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
      .wrap(buildAwsValue())
}
object DeleteRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest =
      zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest(
        featureGroupName,
        recordIdentifierValueAsString,
        eventTime,
        targetStores.map(value => value),
        deletionMode.map(value => value)
      )
    def featureGroupName: FeatureGroupNameOrArn
    def recordIdentifierValueAsString: ValueAsString
    def eventTime: ValueAsString
    def targetStores
        : Optional[List[zio.aws.sagemakerfeaturestoreruntime.model.TargetStore]]
    def deletionMode
        : Optional[zio.aws.sagemakerfeaturestoreruntime.model.DeletionMode]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupNameOrArn] =
      ZIO.succeed(featureGroupName)
    def getRecordIdentifierValueAsString: ZIO[Any, Nothing, ValueAsString] =
      ZIO.succeed(recordIdentifierValueAsString)
    def getEventTime: ZIO[Any, Nothing, ValueAsString] = ZIO.succeed(eventTime)
    def getTargetStores: ZIO[Any, AwsError, List[
      zio.aws.sagemakerfeaturestoreruntime.model.TargetStore
    ]] = AwsError.unwrapOptionField("targetStores", targetStores)
    def getDeletionMode: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakerfeaturestoreruntime.model.DeletionMode
    ] = AwsError.unwrapOptionField("deletionMode", deletionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest.ReadOnly {
    override val featureGroupName: FeatureGroupNameOrArn =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .FeatureGroupNameOrArn(impl.featureGroupName())
    override val recordIdentifierValueAsString: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.recordIdentifierValueAsString())
    override val eventTime: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.eventTime())
    override val targetStores: Optional[
      List[zio.aws.sagemakerfeaturestoreruntime.model.TargetStore]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetStores())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakerfeaturestoreruntime.model.TargetStore.wrap(item)
        }.toList
      )
    override val deletionMode
        : Optional[zio.aws.sagemakerfeaturestoreruntime.model.DeletionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionMode())
        .map(value =>
          zio.aws.sagemakerfeaturestoreruntime.model.DeletionMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
  ): zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest.ReadOnly =
    new Wrapper(impl)
}
