package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRecordResponse(
    record: Optional[
      Iterable[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse = {
    import GetRecordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse
      .builder()
      .optionallyWith(
        record.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.record)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse
      .wrap(buildAwsValue())
}
object GetRecordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse =
      zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse(
        record.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def record: Optional[
      List[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly]
    ]
    def getRecord: ZIO[Any, AwsError, List[
      zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly
    ]] = AwsError.unwrapOptionField("record", record)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse.ReadOnly {
    override val record: Optional[
      List[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.record())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse
  ): zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse.ReadOnly =
    new Wrapper(impl)
}
