package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.{
  FeatureName,
  ValueAsString,
  FeatureGroupName
}
import scala.jdk.CollectionConverters._
final case class GetRecordRequest(
    featureGroupName: FeatureGroupName,
    recordIdentifierValueAsString: ValueAsString,
    featureNames: Option[Iterable[FeatureName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest = {
    import GetRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest
      .builder()
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .recordIdentifierValueAsString(
        ValueAsString.unwrap(recordIdentifierValueAsString): java.lang.String
      )
      .optionallyWith(
        featureNames.map(value =>
          value.map { item =>
            FeatureName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.featureNames)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest
      .wrap(buildAwsValue())
}
object GetRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest =
      zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest(
        featureGroupName,
        recordIdentifierValueAsString,
        featureNames.map(value => value)
      )
    def featureGroupName: FeatureGroupName
    def recordIdentifierValueAsString: ValueAsString
    def featureNames: Option[List[FeatureName]]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getRecordIdentifierValueAsString: ZIO[Any, Nothing, ValueAsString] =
      ZIO.succeed(recordIdentifierValueAsString)
    def getFeatureNames: ZIO[Any, AwsError, List[FeatureName]] =
      AwsError.unwrapOptionField("featureNames", featureNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest.ReadOnly {
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val recordIdentifierValueAsString: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.recordIdentifierValueAsString())
    override val featureNames: Option[List[FeatureName]] = scala
      .Option(impl.featureNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakerfeaturestoreruntime.model.primitives
            .FeatureName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest
  ): zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest.ReadOnly =
    new Wrapper(impl)
}
