package zio.aws.sagemakerfeaturestoreruntime
import zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.sagemakerfeaturestoreruntime.model.{
  PutRecordRequest,
  GetRecordRequest,
  DeleteRecordRequest,
  BatchGetRecordRequest
}
import zio.test.mock.{Proxy, Mock}
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.SageMakerFeatureStoreRuntimeAsyncClient
object SageMakerFeatureStoreRuntimeMock
    extends Mock[SageMakerFeatureStoreRuntime] {
  object BatchGetRecord
      extends Effect[
        BatchGetRecordRequest,
        AwsError,
        zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse.ReadOnly
      ]
  object DeleteRecord extends Effect[DeleteRecordRequest, AwsError, Unit]
  object GetRecord extends Effect[GetRecordRequest, AwsError, ReadOnly]
  object PutRecord extends Effect[PutRecordRequest, AwsError, Unit]
  val compose: URLayer[Proxy, SageMakerFeatureStoreRuntime] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new SageMakerFeatureStoreRuntime {
          val api: SageMakerFeatureStoreRuntimeAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : SageMakerFeatureStoreRuntime = this
          def batchGetRecord(request: BatchGetRecordRequest): IO[
            AwsError,
            zio.aws.sagemakerfeaturestoreruntime.model.BatchGetRecordResponse.ReadOnly
          ] = proxy(BatchGetRecord, request)
          def deleteRecord(request: DeleteRecordRequest): IO[AwsError, Unit] =
            proxy(DeleteRecord, request)
          def getRecord(request: GetRecordRequest): IO[AwsError, ReadOnly] =
            proxy(GetRecord, request)
          def putRecord(request: PutRecordRequest): IO[AwsError, Unit] =
            proxy(PutRecord, request)
        }
      }
    }
    .toLayer
}
