package zio.aws.sagemakeredge.model
import scala.jdk.CollectionConverters.*
sealed trait ModelState {
  def unwrap: software.amazon.awssdk.services.sagemakeredge.model.ModelState
}
object ModelState {
  def wrap(
      value: software.amazon.awssdk.services.sagemakeredge.model.ModelState
  ): zio.aws.sagemakeredge.model.ModelState = value match {
    case software.amazon.awssdk.services.sagemakeredge.model.ModelState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemakeredge.model.ModelState.DEPLOY =>
      val r = DEPLOY
      r
    case software.amazon.awssdk.services.sagemakeredge.model.ModelState.UNDEPLOY =>
      val r = UNDEPLOY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemakeredge.model.ModelState {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.ModelState =
      software.amazon.awssdk.services.sagemakeredge.model.ModelState.UNKNOWN_TO_SDK_VERSION
  }
  case object DEPLOY extends zio.aws.sagemakeredge.model.ModelState {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.ModelState =
      software.amazon.awssdk.services.sagemakeredge.model.ModelState.DEPLOY
  }
  case object UNDEPLOY extends zio.aws.sagemakeredge.model.ModelState {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.ModelState =
      software.amazon.awssdk.services.sagemakeredge.model.ModelState.UNDEPLOY
  }
}
