package zio.aws.sagemakeredge.model
import zio.aws.sagemakeredge.model.primitives.{Timestamp, Version, ModelName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Model(
    modelName: Optional[ModelName] = Optional.Absent,
    modelVersion: Optional[Version] = Optional.Absent,
    latestSampleTime: Optional[Timestamp] = Optional.Absent,
    latestInference: Optional[Timestamp] = Optional.Absent,
    modelMetrics: Optional[Iterable[zio.aws.sagemakeredge.model.EdgeMetric]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.Model = {
    import Model.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.Model
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(
        latestSampleTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestSampleTime)
      .optionallyWith(
        latestInference.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestInference)
      .optionallyWith(
        modelMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelMetrics)
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.Model.ReadOnly =
    zio.aws.sagemakeredge.model.Model.wrap(buildAwsValue())
}
object Model {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.Model
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.Model =
      zio.aws.sagemakeredge.model.Model(
        modelName.map(value => value),
        modelVersion.map(value => value),
        latestSampleTime.map(value => value),
        latestInference.map(value => value),
        modelMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelName: Optional[ModelName]
    def modelVersion: Optional[Version]
    def latestSampleTime: Optional[Timestamp]
    def latestInference: Optional[Timestamp]
    def modelMetrics
        : Optional[List[zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly]]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getLatestSampleTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestSampleTime", latestSampleTime)
    def getLatestInference: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestInference", latestInference)
    def getModelMetrics: ZIO[Any, AwsError, List[
      zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("modelMetrics", modelMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.Model
  ) extends zio.aws.sagemakeredge.model.Model.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.sagemakeredge.model.primitives.ModelName(value))
    override val modelVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersion())
      .map(value => zio.aws.sagemakeredge.model.primitives.Version(value))
    override val latestSampleTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestSampleTime())
      .map(value => zio.aws.sagemakeredge.model.primitives.Timestamp(value))
    override val latestInference: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestInference())
      .map(value => zio.aws.sagemakeredge.model.primitives.Timestamp(value))
    override val modelMetrics
        : Optional[List[zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemakeredge.model.EdgeMetric.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.Model
  ): zio.aws.sagemakeredge.model.Model.ReadOnly = new Wrapper(impl)
}
