package zio.aws.sagemakeredge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakeredge.model.primitives.{Version, ModelName, EntityName}
import scala.jdk.CollectionConverters.*
final case class DeploymentModel(
    modelHandle: Optional[EntityName] = Optional.Absent,
    modelName: Optional[ModelName] = Optional.Absent,
    modelVersion: Optional[Version] = Optional.Absent,
    desiredState: Optional[zio.aws.sagemakeredge.model.ModelState] =
      Optional.Absent,
    state: Optional[zio.aws.sagemakeredge.model.ModelState] = Optional.Absent,
    status: Optional[zio.aws.sagemakeredge.model.DeploymentStatus] =
      Optional.Absent,
    statusReason: Optional[String] = Optional.Absent,
    rollbackFailureReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.DeploymentModel = {
    import DeploymentModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.DeploymentModel
      .builder()
      .optionallyWith(
        modelHandle.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.modelHandle)
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(desiredState.map(value => value.unwrap))(_.desiredState)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(
        rollbackFailureReason.map(value => value: java.lang.String)
      )(_.rollbackFailureReason)
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.DeploymentModel.ReadOnly =
    zio.aws.sagemakeredge.model.DeploymentModel.wrap(buildAwsValue())
}
object DeploymentModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.DeploymentModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.DeploymentModel =
      zio.aws.sagemakeredge.model.DeploymentModel(
        modelHandle.map(value => value),
        modelName.map(value => value),
        modelVersion.map(value => value),
        desiredState.map(value => value),
        state.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        rollbackFailureReason.map(value => value)
      )
    def modelHandle: Optional[EntityName]
    def modelName: Optional[ModelName]
    def modelVersion: Optional[Version]
    def desiredState: Optional[zio.aws.sagemakeredge.model.ModelState]
    def state: Optional[zio.aws.sagemakeredge.model.ModelState]
    def status: Optional[zio.aws.sagemakeredge.model.DeploymentStatus]
    def statusReason: Optional[String]
    def rollbackFailureReason: Optional[String]
    def getModelHandle: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelHandle", modelHandle)
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getDesiredState
        : ZIO[Any, AwsError, zio.aws.sagemakeredge.model.ModelState] =
      AwsError.unwrapOptionField("desiredState", desiredState)
    def getState: ZIO[Any, AwsError, zio.aws.sagemakeredge.model.ModelState] =
      AwsError.unwrapOptionField("state", state)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.sagemakeredge.model.DeploymentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getRollbackFailureReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rollbackFailureReason", rollbackFailureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.DeploymentModel
  ) extends zio.aws.sagemakeredge.model.DeploymentModel.ReadOnly {
    override val modelHandle: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelHandle())
      .map(value => zio.aws.sagemakeredge.model.primitives.EntityName(value))
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.sagemakeredge.model.primitives.ModelName(value))
    override val modelVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersion())
      .map(value => zio.aws.sagemakeredge.model.primitives.Version(value))
    override val desiredState
        : Optional[zio.aws.sagemakeredge.model.ModelState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredState())
        .map(value => zio.aws.sagemakeredge.model.ModelState.wrap(value))
    override val state: Optional[zio.aws.sagemakeredge.model.ModelState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.sagemakeredge.model.ModelState.wrap(value))
    override val status
        : Optional[zio.aws.sagemakeredge.model.DeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemakeredge.model.DeploymentStatus.wrap(value))
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val rollbackFailureReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackFailureReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.DeploymentModel
  ): zio.aws.sagemakeredge.model.DeploymentModel.ReadOnly = new Wrapper(impl)
}
