package zio.aws.sagemakeredge.model
import scala.jdk.CollectionConverters.*
sealed trait ChecksumType {
  def unwrap: software.amazon.awssdk.services.sagemakeredge.model.ChecksumType
}
object ChecksumType {
  def wrap(
      value: software.amazon.awssdk.services.sagemakeredge.model.ChecksumType
  ): zio.aws.sagemakeredge.model.ChecksumType = value match {
    case software.amazon.awssdk.services.sagemakeredge.model.ChecksumType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemakeredge.model.ChecksumType.SHA1 =>
      val r = SHA1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemakeredge.model.ChecksumType {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.ChecksumType =
      software.amazon.awssdk.services.sagemakeredge.model.ChecksumType.UNKNOWN_TO_SDK_VERSION
  }
  case object SHA1 extends zio.aws.sagemakeredge.model.ChecksumType {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.ChecksumType =
      software.amazon.awssdk.services.sagemakeredge.model.ChecksumType.SHA1
  }
}
