package zio.aws.sagemakeredge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakeredge.model.primitives.{
  DeviceFleetName,
  DeviceName,
  Version
}
import scala.jdk.CollectionConverters.*
final case class SendHeartbeatRequest(
    agentMetrics: Optional[Iterable[zio.aws.sagemakeredge.model.EdgeMetric]] =
      Optional.Absent,
    models: Optional[Iterable[zio.aws.sagemakeredge.model.Model]] =
      Optional.Absent,
    agentVersion: Version,
    deviceName: DeviceName,
    deviceFleetName: DeviceFleetName,
    deploymentResult: Optional[zio.aws.sagemakeredge.model.DeploymentResult] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest = {
    import SendHeartbeatRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest
      .builder()
      .optionallyWith(
        agentMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.agentMetrics)
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .agentVersion(Version.unwrap(agentVersion): java.lang.String)
      .deviceName(DeviceName.unwrap(deviceName): java.lang.String)
      .deviceFleetName(
        DeviceFleetName.unwrap(deviceFleetName): java.lang.String
      )
      .optionallyWith(deploymentResult.map(value => value.buildAwsValue()))(
        _.deploymentResult
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.SendHeartbeatRequest.ReadOnly =
    zio.aws.sagemakeredge.model.SendHeartbeatRequest.wrap(buildAwsValue())
}
object SendHeartbeatRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.SendHeartbeatRequest =
      zio.aws.sagemakeredge.model.SendHeartbeatRequest(
        agentMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        agentVersion,
        deviceName,
        deviceFleetName,
        deploymentResult.map(value => value.asEditable)
      )
    def agentMetrics
        : Optional[List[zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly]]
    def models: Optional[List[zio.aws.sagemakeredge.model.Model.ReadOnly]]
    def agentVersion: Version
    def deviceName: DeviceName
    def deviceFleetName: DeviceFleetName
    def deploymentResult
        : Optional[zio.aws.sagemakeredge.model.DeploymentResult.ReadOnly]
    def getAgentMetrics: ZIO[Any, AwsError, List[
      zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("agentMetrics", agentMetrics)
    def getModels
        : ZIO[Any, AwsError, List[zio.aws.sagemakeredge.model.Model.ReadOnly]] =
      AwsError.unwrapOptionField("models", models)
    def getAgentVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(agentVersion)
    def getDeviceName: ZIO[Any, Nothing, DeviceName] = ZIO.succeed(deviceName)
    def getDeviceFleetName: ZIO[Any, Nothing, DeviceFleetName] =
      ZIO.succeed(deviceFleetName)
    def getDeploymentResult: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakeredge.model.DeploymentResult.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentResult", deploymentResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest
  ) extends zio.aws.sagemakeredge.model.SendHeartbeatRequest.ReadOnly {
    override val agentMetrics
        : Optional[List[zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agentMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemakeredge.model.EdgeMetric.wrap(item)
          }.toList
        )
    override val models
        : Optional[List[zio.aws.sagemakeredge.model.Model.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.models())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemakeredge.model.Model.wrap(item)
          }.toList
        )
    override val agentVersion: Version =
      zio.aws.sagemakeredge.model.primitives.Version(impl.agentVersion())
    override val deviceName: DeviceName =
      zio.aws.sagemakeredge.model.primitives.DeviceName(impl.deviceName())
    override val deviceFleetName: DeviceFleetName =
      zio.aws.sagemakeredge.model.primitives
        .DeviceFleetName(impl.deviceFleetName())
    override val deploymentResult
        : Optional[zio.aws.sagemakeredge.model.DeploymentResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentResult())
        .map(value => zio.aws.sagemakeredge.model.DeploymentResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest
  ): zio.aws.sagemakeredge.model.SendHeartbeatRequest.ReadOnly = new Wrapper(
    impl
  )
}
