package zio.aws.sagemakeredge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakeredge.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class EdgeDeployment(
    deploymentName: Optional[EntityName] = Optional.Absent,
    `type`: Optional[zio.aws.sagemakeredge.model.DeploymentType] =
      Optional.Absent,
    failureHandlingPolicy: Optional[
      zio.aws.sagemakeredge.model.FailureHandlingPolicy
    ] = Optional.Absent,
    definitions: Optional[Iterable[zio.aws.sagemakeredge.model.Definition]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.EdgeDeployment = {
    import EdgeDeployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.EdgeDeployment
      .builder()
      .optionallyWith(
        deploymentName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.deploymentName)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(failureHandlingPolicy.map(value => value.unwrap))(
        _.failureHandlingPolicy
      )
      .optionallyWith(
        definitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.definitions)
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.EdgeDeployment.ReadOnly =
    zio.aws.sagemakeredge.model.EdgeDeployment.wrap(buildAwsValue())
}
object EdgeDeployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.EdgeDeployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.EdgeDeployment =
      zio.aws.sagemakeredge.model.EdgeDeployment(
        deploymentName.map(value => value),
        `type`.map(value => value),
        failureHandlingPolicy.map(value => value),
        definitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deploymentName: Optional[EntityName]
    def `type`: Optional[zio.aws.sagemakeredge.model.DeploymentType]
    def failureHandlingPolicy
        : Optional[zio.aws.sagemakeredge.model.FailureHandlingPolicy]
    def definitions
        : Optional[List[zio.aws.sagemakeredge.model.Definition.ReadOnly]]
    def getDeploymentName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("deploymentName", deploymentName)
    def getType
        : ZIO[Any, AwsError, zio.aws.sagemakeredge.model.DeploymentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getFailureHandlingPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakeredge.model.FailureHandlingPolicy
    ] =
      AwsError.unwrapOptionField("failureHandlingPolicy", failureHandlingPolicy)
    def getDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemakeredge.model.Definition.ReadOnly
    ]] = AwsError.unwrapOptionField("definitions", definitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.EdgeDeployment
  ) extends zio.aws.sagemakeredge.model.EdgeDeployment.ReadOnly {
    override val deploymentName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentName())
      .map(value => zio.aws.sagemakeredge.model.primitives.EntityName(value))
    override val `type`: Optional[zio.aws.sagemakeredge.model.DeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.sagemakeredge.model.DeploymentType.wrap(value))
    override val failureHandlingPolicy
        : Optional[zio.aws.sagemakeredge.model.FailureHandlingPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureHandlingPolicy())
        .map(value =>
          zio.aws.sagemakeredge.model.FailureHandlingPolicy.wrap(value)
        )
    override val definitions
        : Optional[List[zio.aws.sagemakeredge.model.Definition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.definitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemakeredge.model.Definition.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.EdgeDeployment
  ): zio.aws.sagemakeredge.model.EdgeDeployment.ReadOnly = new Wrapper(impl)
}
