package zio.aws.sagemakeredge.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentType {
  def unwrap: software.amazon.awssdk.services.sagemakeredge.model.DeploymentType
}
object DeploymentType {
  def wrap(
      value: software.amazon.awssdk.services.sagemakeredge.model.DeploymentType
  ): zio.aws.sagemakeredge.model.DeploymentType = value match {
    case software.amazon.awssdk.services.sagemakeredge.model.DeploymentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemakeredge.model.DeploymentType.MODEL =>
      val r = Model
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemakeredge.model.DeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.DeploymentType =
      software.amazon.awssdk.services.sagemakeredge.model.DeploymentType.UNKNOWN_TO_SDK_VERSION
  }
  case object Model extends zio.aws.sagemakeredge.model.DeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.DeploymentType =
      software.amazon.awssdk.services.sagemakeredge.model.DeploymentType.MODEL
  }
}
