package zio.aws.sagemakeredge.model
import zio.aws.sagemakeredge.model.primitives.{
  Timestamp,
  Value,
  Metric,
  Dimension
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EdgeMetric(
    dimension: Optional[Dimension] = Optional.Absent,
    metricName: Optional[Metric] = Optional.Absent,
    value: Optional[Value] = Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.EdgeMetric = {
    import EdgeMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.EdgeMetric
      .builder()
      .optionallyWith(
        dimension.map(value => Dimension.unwrap(value): java.lang.String)
      )(_.dimension)
      .optionallyWith(
        metricName.map(value => Metric.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        value.map(value => Value.unwrap(value): java.lang.Double)
      )(_.value)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly =
    zio.aws.sagemakeredge.model.EdgeMetric.wrap(buildAwsValue())
}
object EdgeMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.EdgeMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.EdgeMetric =
      zio.aws.sagemakeredge.model.EdgeMetric(
        dimension.map(value => value),
        metricName.map(value => value),
        value.map(value => value),
        timestamp.map(value => value)
      )
    def dimension: Optional[Dimension]
    def metricName: Optional[Metric]
    def value: Optional[Value]
    def timestamp: Optional[Timestamp]
    def getDimension: ZIO[Any, AwsError, Dimension] =
      AwsError.unwrapOptionField("dimension", dimension)
    def getMetricName: ZIO[Any, AwsError, Metric] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.EdgeMetric
  ) extends zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly {
    override val dimension: Optional[Dimension] = zio.aws.core.internal
      .optionalFromNullable(impl.dimension())
      .map(value => zio.aws.sagemakeredge.model.primitives.Dimension(value))
    override val metricName: Optional[Metric] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.sagemakeredge.model.primitives.Metric(value))
    override val value: Optional[Value] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.sagemakeredge.model.primitives.Value(value))
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.sagemakeredge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.EdgeMetric
  ): zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly = new Wrapper(impl)
}
