package zio.aws.sagemakeredge
import software.amazon.awssdk.services.sagemakeredge.SagemakerEdgeAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.sagemakeredge.model.GetDeviceRegistrationResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.sagemakeredge.model.{
  SendHeartbeatRequest,
  GetDeviceRegistrationRequest
}
object SagemakerEdgeMock extends Mock[SagemakerEdge] {
  object GetDeviceRegistration
      extends Effect[GetDeviceRegistrationRequest, AwsError, ReadOnly]
  object SendHeartbeat extends Effect[SendHeartbeatRequest, AwsError, Unit]
  val compose: URLayer[Proxy, SagemakerEdge] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new SagemakerEdge {
          val api: SagemakerEdgeAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : SagemakerEdge = this
          def getDeviceRegistration(
              request: GetDeviceRegistrationRequest
          ): IO[AwsError, ReadOnly] = proxy(GetDeviceRegistration, request)
          def sendHeartbeat(request: SendHeartbeatRequest): IO[AwsError, Unit] =
            proxy(SendHeartbeat, request)
        }
      }
    }
  }
}
