package zio.aws.sagemakeredge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDeploymentsResponse(
    deployments: Optional[
      Iterable[zio.aws.sagemakeredge.model.EdgeDeployment]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsResponse = {
    import GetDeploymentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsResponse
      .builder()
      .optionallyWith(
        deployments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deployments)
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.GetDeploymentsResponse.ReadOnly =
    zio.aws.sagemakeredge.model.GetDeploymentsResponse.wrap(buildAwsValue())
}
object GetDeploymentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.GetDeploymentsResponse =
      zio.aws.sagemakeredge.model.GetDeploymentsResponse(
        deployments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deployments
        : Optional[List[zio.aws.sagemakeredge.model.EdgeDeployment.ReadOnly]]
    def getDeployments: ZIO[Any, AwsError, List[
      zio.aws.sagemakeredge.model.EdgeDeployment.ReadOnly
    ]] = AwsError.unwrapOptionField("deployments", deployments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsResponse
  ) extends zio.aws.sagemakeredge.model.GetDeploymentsResponse.ReadOnly {
    override val deployments
        : Optional[List[zio.aws.sagemakeredge.model.EdgeDeployment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deployments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemakeredge.model.EdgeDeployment.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsResponse
  ): zio.aws.sagemakeredge.model.GetDeploymentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
