package zio.aws.sagemakeredge.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus
}
object DeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus
  ): zio.aws.sagemakeredge.model.DeploymentStatus = value match {
    case software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus.FAIL =>
      val r = FAIL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemakeredge.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus =
      software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.sagemakeredge.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus =
      software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus.SUCCESS
  }
  case object FAIL extends zio.aws.sagemakeredge.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus =
      software.amazon.awssdk.services.sagemakeredge.model.DeploymentStatus.FAIL
  }
}
