package zio.aws.sagemakeredge.model
import zio.aws.sagemakeredge.model.primitives.{Timestamp, EntityName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DeploymentResult(
    deploymentName: Optional[EntityName] = Optional.Absent,
    deploymentStatus: Optional[EntityName] = Optional.Absent,
    deploymentStatusMessage: Optional[String] = Optional.Absent,
    deploymentStartTime: Optional[Timestamp] = Optional.Absent,
    deploymentEndTime: Optional[Timestamp] = Optional.Absent,
    deploymentModels: Optional[
      Iterable[zio.aws.sagemakeredge.model.DeploymentModel]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.DeploymentResult = {
    import DeploymentResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.DeploymentResult
      .builder()
      .optionallyWith(
        deploymentName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.deploymentName)
      .optionallyWith(
        deploymentStatus.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.deploymentStatus)
      .optionallyWith(
        deploymentStatusMessage.map(value => value: java.lang.String)
      )(_.deploymentStatusMessage)
      .optionallyWith(
        deploymentStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.deploymentStartTime)
      .optionallyWith(
        deploymentEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.deploymentEndTime)
      .optionallyWith(
        deploymentModels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deploymentModels)
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.DeploymentResult.ReadOnly =
    zio.aws.sagemakeredge.model.DeploymentResult.wrap(buildAwsValue())
}
object DeploymentResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.DeploymentResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.DeploymentResult =
      zio.aws.sagemakeredge.model.DeploymentResult(
        deploymentName.map(value => value),
        deploymentStatus.map(value => value),
        deploymentStatusMessage.map(value => value),
        deploymentStartTime.map(value => value),
        deploymentEndTime.map(value => value),
        deploymentModels.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deploymentName: Optional[EntityName]
    def deploymentStatus: Optional[EntityName]
    def deploymentStatusMessage: Optional[String]
    def deploymentStartTime: Optional[Timestamp]
    def deploymentEndTime: Optional[Timestamp]
    def deploymentModels
        : Optional[List[zio.aws.sagemakeredge.model.DeploymentModel.ReadOnly]]
    def getDeploymentName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("deploymentName", deploymentName)
    def getDeploymentStatus: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getDeploymentStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deploymentStartTime", deploymentStartTime)
    def getDeploymentEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deploymentEndTime", deploymentEndTime)
    def getDeploymentModels: ZIO[Any, AwsError, List[
      zio.aws.sagemakeredge.model.DeploymentModel.ReadOnly
    ]] = AwsError.unwrapOptionField("deploymentModels", deploymentModels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.DeploymentResult
  ) extends zio.aws.sagemakeredge.model.DeploymentResult.ReadOnly {
    override val deploymentName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentName())
      .map(value => zio.aws.sagemakeredge.model.primitives.EntityName(value))
    override val deploymentStatus: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentStatus())
      .map(value => zio.aws.sagemakeredge.model.primitives.EntityName(value))
    override val deploymentStatusMessage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessage())
        .map(value => value: String)
    override val deploymentStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStartTime())
        .map(value => zio.aws.sagemakeredge.model.primitives.Timestamp(value))
    override val deploymentEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentEndTime())
      .map(value => zio.aws.sagemakeredge.model.primitives.Timestamp(value))
    override val deploymentModels
        : Optional[List[zio.aws.sagemakeredge.model.DeploymentModel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentModels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemakeredge.model.DeploymentModel.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.DeploymentResult
  ): zio.aws.sagemakeredge.model.DeploymentResult.ReadOnly = new Wrapper(impl)
}
