package zio.aws.sagemakeredge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakeredge.model.primitives.{S3Uri, EntityName}
import scala.jdk.CollectionConverters._
final case class Definition(
    modelHandle: Optional[EntityName] = Optional.Absent,
    s3Url: Optional[S3Uri] = Optional.Absent,
    checksum: Optional[zio.aws.sagemakeredge.model.Checksum] = Optional.Absent,
    state: Optional[zio.aws.sagemakeredge.model.ModelState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.Definition = {
    import Definition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.Definition
      .builder()
      .optionallyWith(
        modelHandle.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.modelHandle)
      .optionallyWith(
        s3Url.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3Url)
      .optionallyWith(checksum.map(value => value.buildAwsValue()))(_.checksum)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.Definition.ReadOnly =
    zio.aws.sagemakeredge.model.Definition.wrap(buildAwsValue())
}
object Definition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.Definition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.Definition =
      zio.aws.sagemakeredge.model.Definition(
        modelHandle.map(value => value),
        s3Url.map(value => value),
        checksum.map(value => value.asEditable),
        state.map(value => value)
      )
    def modelHandle: Optional[EntityName]
    def s3Url: Optional[S3Uri]
    def checksum: Optional[zio.aws.sagemakeredge.model.Checksum.ReadOnly]
    def state: Optional[zio.aws.sagemakeredge.model.ModelState]
    def getModelHandle: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelHandle", modelHandle)
    def getS3Url: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3Url", s3Url)
    def getChecksum
        : ZIO[Any, AwsError, zio.aws.sagemakeredge.model.Checksum.ReadOnly] =
      AwsError.unwrapOptionField("checksum", checksum)
    def getState: ZIO[Any, AwsError, zio.aws.sagemakeredge.model.ModelState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.Definition
  ) extends zio.aws.sagemakeredge.model.Definition.ReadOnly {
    override val modelHandle: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelHandle())
      .map(value => zio.aws.sagemakeredge.model.primitives.EntityName(value))
    override val s3Url: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Url())
      .map(value => zio.aws.sagemakeredge.model.primitives.S3Uri(value))
    override val checksum
        : Optional[zio.aws.sagemakeredge.model.Checksum.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksum())
        .map(value => zio.aws.sagemakeredge.model.Checksum.wrap(value))
    override val state: Optional[zio.aws.sagemakeredge.model.ModelState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.sagemakeredge.model.ModelState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.Definition
  ): zio.aws.sagemakeredge.model.Definition.ReadOnly = new Wrapper(impl)
}
