package zio.aws.sagemakeredge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakeredge.model.primitives.ChecksumString
import scala.jdk.CollectionConverters._
final case class Checksum(
    `type`: Optional[zio.aws.sagemakeredge.model.ChecksumType] =
      Optional.Absent,
    sum: Optional[ChecksumString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.Checksum = {
    import Checksum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.Checksum
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        sum.map(value => ChecksumString.unwrap(value): java.lang.String)
      )(_.sum)
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.Checksum.ReadOnly =
    zio.aws.sagemakeredge.model.Checksum.wrap(buildAwsValue())
}
object Checksum {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.Checksum
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.Checksum =
      zio.aws.sagemakeredge.model
        .Checksum(`type`.map(value => value), sum.map(value => value))
    def `type`: Optional[zio.aws.sagemakeredge.model.ChecksumType]
    def sum: Optional[ChecksumString]
    def getType: ZIO[Any, AwsError, zio.aws.sagemakeredge.model.ChecksumType] =
      AwsError.unwrapOptionField("type", `type`)
    def getSum: ZIO[Any, AwsError, ChecksumString] =
      AwsError.unwrapOptionField("sum", sum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.Checksum
  ) extends zio.aws.sagemakeredge.model.Checksum.ReadOnly {
    override val `type`: Optional[zio.aws.sagemakeredge.model.ChecksumType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.sagemakeredge.model.ChecksumType.wrap(value))
    override val sum: Optional[ChecksumString] = zio.aws.core.internal
      .optionalFromNullable(impl.sum())
      .map(value =>
        zio.aws.sagemakeredge.model.primitives.ChecksumString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.Checksum
  ): zio.aws.sagemakeredge.model.Checksum.ReadOnly = new Wrapper(impl)
}
