package zio.aws.sagemakeredge.model
import scala.jdk.CollectionConverters._
sealed trait FailureHandlingPolicy {
  def unwrap: software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy
}
object FailureHandlingPolicy {
  def wrap(
      value: software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy
  ): zio.aws.sagemakeredge.model.FailureHandlingPolicy = value match {
    case software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy.ROLLBACK_ON_FAILURE =>
      val r = ROLLBACK_ON_FAILURE
      r
    case software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy.DO_NOTHING =>
      val r = DO_NOTHING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemakeredge.model.FailureHandlingPolicy {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy =
      software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object ROLLBACK_ON_FAILURE
      extends zio.aws.sagemakeredge.model.FailureHandlingPolicy {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy =
      software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy.ROLLBACK_ON_FAILURE
  }
  case object DO_NOTHING
      extends zio.aws.sagemakeredge.model.FailureHandlingPolicy {
    override def unwrap
        : software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy =
      software.amazon.awssdk.services.sagemakeredge.model.FailureHandlingPolicy.DO_NOTHING
  }
}
