package zio.aws.sagemakeredge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemakeredge.model.primitives.{DeviceFleetName, DeviceName}
import scala.jdk.CollectionConverters._
final case class GetDeploymentsRequest(
    deviceName: DeviceName,
    deviceFleetName: DeviceFleetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsRequest = {
    import GetDeploymentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsRequest
      .builder()
      .deviceName(DeviceName.unwrap(deviceName): java.lang.String)
      .deviceFleetName(
        DeviceFleetName.unwrap(deviceFleetName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.GetDeploymentsRequest.ReadOnly =
    zio.aws.sagemakeredge.model.GetDeploymentsRequest.wrap(buildAwsValue())
}
object GetDeploymentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.GetDeploymentsRequest =
      zio.aws.sagemakeredge.model
        .GetDeploymentsRequest(deviceName, deviceFleetName)
    def deviceName: DeviceName
    def deviceFleetName: DeviceFleetName
    def getDeviceName: ZIO[Any, Nothing, DeviceName] = ZIO.succeed(deviceName)
    def getDeviceFleetName: ZIO[Any, Nothing, DeviceFleetName] =
      ZIO.succeed(deviceFleetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsRequest
  ) extends zio.aws.sagemakeredge.model.GetDeploymentsRequest.ReadOnly {
    override val deviceName: DeviceName =
      zio.aws.sagemakeredge.model.primitives.DeviceName(impl.deviceName())
    override val deviceFleetName: DeviceFleetName =
      zio.aws.sagemakeredge.model.primitives
        .DeviceFleetName(impl.deviceFleetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.GetDeploymentsRequest
  ): zio.aws.sagemakeredge.model.GetDeploymentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
