package zio.aws.sagemakeredge
import software.amazon.awssdk.services.sagemakeredge.model.{
  SendHeartbeatResponse,
  SendHeartbeatRequest,
  GetDeviceRegistrationResponse,
  GetDeviceRegistrationRequest
}
import software.amazon.awssdk.services.sagemakeredge.{
  SagemakerEdgeAsyncClientBuilder,
  SagemakerEdgeAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.sagemakeredge.model.GetDeviceRegistrationResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import scala.jdk.CollectionConverters._
trait SagemakerEdge extends AspectSupport[SagemakerEdge] {
  val api: SagemakerEdgeAsyncClient
  def getDeviceRegistration(
      request: zio.aws.sagemakeredge.model.GetDeviceRegistrationRequest
  ): IO[AwsError, ReadOnly]
  def sendHeartbeat(
      request: zio.aws.sagemakeredge.model.SendHeartbeatRequest
  ): IO[AwsError, Unit]
}
object SagemakerEdge {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SagemakerEdge] = customized(
    identity
  )
  def customized(
      customization: SagemakerEdgeAsyncClientBuilder => SagemakerEdgeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SagemakerEdge] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SagemakerEdgeAsyncClientBuilder => SagemakerEdgeAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SagemakerEdge] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SagemakerEdgeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SagemakerEdgeAsyncClient, SagemakerEdgeAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      SagemakerEdgeAsyncClient,
      SagemakerEdgeAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new SagemakerEdgeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SagemakerEdgeImpl[R](
      override val api: SagemakerEdgeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SagemakerEdge
      with AwsServiceBase[R] {
    override val serviceName: String = "SagemakerEdge"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SagemakerEdgeImpl[R1] = new SagemakerEdgeImpl(api, newAspect, r)
    def getDeviceRegistration(
        request: zio.aws.sagemakeredge.model.GetDeviceRegistrationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      GetDeviceRegistrationRequest,
      GetDeviceRegistrationResponse
    ]("getDeviceRegistration", api.getDeviceRegistration)(
      request.buildAwsValue()
    ).map(zio.aws.sagemakeredge.model.GetDeviceRegistrationResponse.wrap)
      .provideEnvironment(r)
    def sendHeartbeat(
        request: zio.aws.sagemakeredge.model.SendHeartbeatRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[SendHeartbeatRequest, SendHeartbeatResponse](
        "sendHeartbeat",
        api.sendHeartbeat
      )(request.buildAwsValue()).unit.provideEnvironment(r)
  }
  def getDeviceRegistration(
      request: zio.aws.sagemakeredge.model.GetDeviceRegistrationRequest
  ): ZIO[zio.aws.sagemakeredge.SagemakerEdge, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getDeviceRegistration(request))
  def sendHeartbeat(
      request: zio.aws.sagemakeredge.model.SendHeartbeatRequest
  ): ZIO[zio.aws.sagemakeredge.SagemakerEdge, AwsError, Unit] =
    ZIO.serviceWithZIO(_.sendHeartbeat(request))
}
