package zio.aws.sagemakeredge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakeredge.model.primitives.{
  CacheTTLSeconds,
  DeviceRegistration
}
import scala.jdk.CollectionConverters._
final case class GetDeviceRegistrationResponse(
    deviceRegistration: Optional[DeviceRegistration] = Optional.Absent,
    cacheTTL: Optional[CacheTTLSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.GetDeviceRegistrationResponse = {
    import GetDeviceRegistrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.GetDeviceRegistrationResponse
      .builder()
      .optionallyWith(
        deviceRegistration.map(value =>
          DeviceRegistration.unwrap(value): java.lang.String
        )
      )(_.deviceRegistration)
      .optionallyWith(
        cacheTTL.map(value => CacheTTLSeconds.unwrap(value): java.lang.String)
      )(_.cacheTTL)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakeredge.model.GetDeviceRegistrationResponse.ReadOnly =
    zio.aws.sagemakeredge.model.GetDeviceRegistrationResponse
      .wrap(buildAwsValue())
}
object GetDeviceRegistrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.GetDeviceRegistrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.GetDeviceRegistrationResponse =
      zio.aws.sagemakeredge.model.GetDeviceRegistrationResponse(
        deviceRegistration.map(value => value),
        cacheTTL.map(value => value)
      )
    def deviceRegistration: Optional[DeviceRegistration]
    def cacheTTL: Optional[CacheTTLSeconds]
    def getDeviceRegistration: ZIO[Any, AwsError, DeviceRegistration] =
      AwsError.unwrapOptionField("deviceRegistration", deviceRegistration)
    def getCacheTTL: ZIO[Any, AwsError, CacheTTLSeconds] =
      AwsError.unwrapOptionField("cacheTTL", cacheTTL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.GetDeviceRegistrationResponse
  ) extends zio.aws.sagemakeredge.model.GetDeviceRegistrationResponse.ReadOnly {
    override val deviceRegistration: Optional[DeviceRegistration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceRegistration())
        .map(value =>
          zio.aws.sagemakeredge.model.primitives.DeviceRegistration(value)
        )
    override val cacheTTL: Optional[CacheTTLSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheTTL())
      .map(value =>
        zio.aws.sagemakeredge.model.primitives.CacheTTLSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.GetDeviceRegistrationResponse
  ): zio.aws.sagemakeredge.model.GetDeviceRegistrationResponse.ReadOnly =
    new Wrapper(impl)
}
