package zio.aws.sagemakeredge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakeredge.model.primitives.{
  DeviceFleetName,
  DeviceName,
  Version
}
import scala.jdk.CollectionConverters._
final case class SendHeartbeatRequest(
    agentMetrics: Option[Iterable[zio.aws.sagemakeredge.model.EdgeMetric]] =
      None,
    models: Option[Iterable[zio.aws.sagemakeredge.model.Model]] = None,
    agentVersion: Version,
    deviceName: DeviceName,
    deviceFleetName: DeviceFleetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest = {
    import SendHeartbeatRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest
      .builder()
      .optionallyWith(
        agentMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.agentMetrics)
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .agentVersion(Version.unwrap(agentVersion): java.lang.String)
      .deviceName(DeviceName.unwrap(deviceName): java.lang.String)
      .deviceFleetName(
        DeviceFleetName.unwrap(deviceFleetName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemakeredge.model.SendHeartbeatRequest.ReadOnly =
    zio.aws.sagemakeredge.model.SendHeartbeatRequest.wrap(buildAwsValue())
}
object SendHeartbeatRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakeredge.model.SendHeartbeatRequest =
      zio.aws.sagemakeredge.model.SendHeartbeatRequest(
        agentMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        agentVersion,
        deviceName,
        deviceFleetName
      )
    def agentMetrics
        : Option[List[zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly]]
    def models: Option[List[zio.aws.sagemakeredge.model.Model.ReadOnly]]
    def agentVersion: Version
    def deviceName: DeviceName
    def deviceFleetName: DeviceFleetName
    def getAgentMetrics: ZIO[Any, AwsError, List[
      zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("agentMetrics", agentMetrics)
    def getModels
        : ZIO[Any, AwsError, List[zio.aws.sagemakeredge.model.Model.ReadOnly]] =
      AwsError.unwrapOptionField("models", models)
    def getAgentVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(agentVersion)
    def getDeviceName: ZIO[Any, Nothing, DeviceName] = ZIO.succeed(deviceName)
    def getDeviceFleetName: ZIO[Any, Nothing, DeviceFleetName] =
      ZIO.succeed(deviceFleetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest
  ) extends zio.aws.sagemakeredge.model.SendHeartbeatRequest.ReadOnly {
    override val agentMetrics
        : Option[List[zio.aws.sagemakeredge.model.EdgeMetric.ReadOnly]] = scala
      .Option(impl.agentMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakeredge.model.EdgeMetric.wrap(item)
        }.toList
      )
    override val models
        : Option[List[zio.aws.sagemakeredge.model.Model.ReadOnly]] = scala
      .Option(impl.models())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakeredge.model.Model.wrap(item)
        }.toList
      )
    override val agentVersion: Version =
      zio.aws.sagemakeredge.model.primitives.Version(impl.agentVersion())
    override val deviceName: DeviceName =
      zio.aws.sagemakeredge.model.primitives.DeviceName(impl.deviceName())
    override val deviceFleetName: DeviceFleetName =
      zio.aws.sagemakeredge.model.primitives
        .DeviceFleetName(impl.deviceFleetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakeredge.model.SendHeartbeatRequest
  ): zio.aws.sagemakeredge.model.SendHeartbeatRequest.ReadOnly = new Wrapper(
    impl
  )
}
