package zio.aws.sagemakera2iruntime.model
import scala.jdk.CollectionConverters.*
sealed trait HumanLoopStatus {
  def unwrap: software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus
}
object HumanLoopStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus
  ): zio.aws.sagemakera2iruntime.model.HumanLoopStatus = value match {
    case software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.STOPPING =>
      val r = Stopping
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemakera2iruntime.model.HumanLoopStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus =
      software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress
      extends zio.aws.sagemakera2iruntime.model.HumanLoopStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus =
      software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.IN_PROGRESS
  }
  case object Failed extends zio.aws.sagemakera2iruntime.model.HumanLoopStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus =
      software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.FAILED
  }
  case object Completed
      extends zio.aws.sagemakera2iruntime.model.HumanLoopStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus =
      software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.COMPLETED
  }
  case object Stopped
      extends zio.aws.sagemakera2iruntime.model.HumanLoopStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus =
      software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.STOPPED
  }
  case object Stopping
      extends zio.aws.sagemakera2iruntime.model.HumanLoopStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus =
      software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus.STOPPING
  }
}
