package zio.aws.sagemakera2iruntime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.sagemakera2iruntime.model.primitives.{
  FlowDefinitionArn,
  FailureReason,
  Timestamp,
  HumanLoopName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class HumanLoopSummary(
    humanLoopName: Optional[HumanLoopName] = Optional.Absent,
    humanLoopStatus: Optional[
      zio.aws.sagemakera2iruntime.model.HumanLoopStatus
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    flowDefinitionArn: Optional[FlowDefinitionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary = {
    import HumanLoopSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary
      .builder()
      .optionallyWith(
        humanLoopName.map(value =>
          HumanLoopName.unwrap(value): java.lang.String
        )
      )(_.humanLoopName)
      .optionallyWith(humanLoopStatus.map(value => value.unwrap))(
        _.humanLoopStatus
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        flowDefinitionArn.map(value =>
          FlowDefinitionArn.unwrap(value): java.lang.String
        )
      )(_.flowDefinitionArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly =
    zio.aws.sagemakera2iruntime.model.HumanLoopSummary.wrap(buildAwsValue())
}
object HumanLoopSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakera2iruntime.model.HumanLoopSummary =
      zio.aws.sagemakera2iruntime.model.HumanLoopSummary(
        humanLoopName.map(value => value),
        humanLoopStatus.map(value => value),
        creationTime.map(value => value),
        failureReason.map(value => value),
        flowDefinitionArn.map(value => value)
      )
    def humanLoopName: Optional[HumanLoopName]
    def humanLoopStatus
        : Optional[zio.aws.sagemakera2iruntime.model.HumanLoopStatus]
    def creationTime: Optional[Timestamp]
    def failureReason: Optional[FailureReason]
    def flowDefinitionArn: Optional[FlowDefinitionArn]
    def getHumanLoopName: ZIO[Any, AwsError, HumanLoopName] =
      AwsError.unwrapOptionField("humanLoopName", humanLoopName)
    def getHumanLoopStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakera2iruntime.model.HumanLoopStatus
    ] = AwsError.unwrapOptionField("humanLoopStatus", humanLoopStatus)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFlowDefinitionArn: ZIO[Any, AwsError, FlowDefinitionArn] =
      AwsError.unwrapOptionField("flowDefinitionArn", flowDefinitionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary
  ) extends zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly {
    override val humanLoopName: Optional[HumanLoopName] = zio.aws.core.internal
      .optionalFromNullable(impl.humanLoopName())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.HumanLoopName(value)
      )
    override val humanLoopStatus
        : Optional[zio.aws.sagemakera2iruntime.model.HumanLoopStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.humanLoopStatus())
        .map(value =>
          zio.aws.sagemakera2iruntime.model.HumanLoopStatus.wrap(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.Timestamp(value)
      )
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.FailureReason(value)
      )
    override val flowDefinitionArn: Optional[FlowDefinitionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowDefinitionArn())
        .map(value =>
          zio.aws.sagemakera2iruntime.model.primitives.FlowDefinitionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary
  ): zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly = new Wrapper(
    impl
  )
}
