package zio.aws.sagemakera2iruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakera2iruntime.model.primitives.HumanLoopArn
import scala.jdk.CollectionConverters.*
final case class StartHumanLoopResponse(
    humanLoopArn: Option[HumanLoopArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopResponse = {
    import StartHumanLoopResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopResponse
      .builder()
      .optionallyWith(
        humanLoopArn.map(value => HumanLoopArn.unwrap(value): java.lang.String)
      )(_.humanLoopArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakera2iruntime.model.StartHumanLoopResponse.ReadOnly =
    zio.aws.sagemakera2iruntime.model.StartHumanLoopResponse
      .wrap(buildAwsValue())
}
object StartHumanLoopResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakera2iruntime.model.StartHumanLoopResponse =
      zio.aws.sagemakera2iruntime.model
        .StartHumanLoopResponse(humanLoopArn.map(value => value))
    def humanLoopArn: Option[HumanLoopArn]
    def getHumanLoopArn: ZIO[Any, AwsError, HumanLoopArn] =
      AwsError.unwrapOptionField("humanLoopArn", humanLoopArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopResponse
  ) extends zio.aws.sagemakera2iruntime.model.StartHumanLoopResponse.ReadOnly {
    override val humanLoopArn: Option[HumanLoopArn] = scala
      .Option(impl.humanLoopArn())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.HumanLoopArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopResponse
  ): zio.aws.sagemakera2iruntime.model.StartHumanLoopResponse.ReadOnly =
    new Wrapper(impl)
}
