package zio.aws.sagemakera2iruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakera2iruntime.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListHumanLoopsResponse(
    humanLoopSummaries: Iterable[
      zio.aws.sagemakera2iruntime.model.HumanLoopSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse = {
    import ListHumanLoopsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse
      .builder()
      .humanLoopSummaries(humanLoopSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse.ReadOnly =
    zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse
      .wrap(buildAwsValue())
}
object ListHumanLoopsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse =
      zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse(
        humanLoopSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def humanLoopSummaries
        : List[zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getHumanLoopSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly
    ]] = ZIO.succeed(humanLoopSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse
  ) extends zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse.ReadOnly {
    override val humanLoopSummaries
        : List[zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly] =
      impl
        .humanLoopSummaries()
        .asScala
        .map { item =>
          zio.aws.sagemakera2iruntime.model.HumanLoopSummary.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsResponse
  ): zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse.ReadOnly =
    new Wrapper(impl)
}
