package zio.aws.sagemakera2iruntime.model
import java.time.Instant
import zio.aws.sagemakera2iruntime.model.primitives.{
  MaxResults,
  NextToken,
  FlowDefinitionArn,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListHumanLoopsRequest(
    creationTimeAfter: Option[Timestamp] = None,
    creationTimeBefore: Option[Timestamp] = None,
    flowDefinitionArn: FlowDefinitionArn,
    sortOrder: Option[zio.aws.sagemakera2iruntime.model.SortOrder] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest = {
    import ListHumanLoopsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .flowDefinitionArn(
        FlowDefinitionArn.unwrap(flowDefinitionArn): java.lang.String
      )
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest.ReadOnly =
    zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest
      .wrap(buildAwsValue())
}
object ListHumanLoopsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest =
      zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        flowDefinitionArn,
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def creationTimeAfter: Option[Timestamp]
    def creationTimeBefore: Option[Timestamp]
    def flowDefinitionArn: FlowDefinitionArn
    def sortOrder: Option[zio.aws.sagemakera2iruntime.model.SortOrder]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getFlowDefinitionArn: ZIO[Any, Nothing, FlowDefinitionArn] =
      ZIO.succeed(flowDefinitionArn)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemakera2iruntime.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest
  ) extends zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest.ReadOnly {
    override val creationTimeAfter: Option[Timestamp] = scala
      .Option(impl.creationTimeAfter())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.Timestamp(value)
      )
    override val creationTimeBefore: Option[Timestamp] = scala
      .Option(impl.creationTimeBefore())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.Timestamp(value)
      )
    override val flowDefinitionArn: FlowDefinitionArn =
      zio.aws.sagemakera2iruntime.model.primitives
        .FlowDefinitionArn(impl.flowDefinitionArn())
    override val sortOrder
        : Option[zio.aws.sagemakera2iruntime.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemakera2iruntime.model.SortOrder.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.NextToken(value)
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest
  ): zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest.ReadOnly =
    new Wrapper(impl)
}
