package zio.aws.sagemakera2iruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakera2iruntime.model.primitives.{
  FlowDefinitionArn,
  HumanLoopName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartHumanLoopRequest(
    humanLoopName: HumanLoopName,
    flowDefinitionArn: FlowDefinitionArn,
    humanLoopInput: zio.aws.sagemakera2iruntime.model.HumanLoopInput,
    dataAttributes: Optional[
      zio.aws.sagemakera2iruntime.model.HumanLoopDataAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopRequest = {
    import StartHumanLoopRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopRequest
      .builder()
      .humanLoopName(HumanLoopName.unwrap(humanLoopName): java.lang.String)
      .flowDefinitionArn(
        FlowDefinitionArn.unwrap(flowDefinitionArn): java.lang.String
      )
      .humanLoopInput(humanLoopInput.buildAwsValue())
      .optionallyWith(dataAttributes.map(value => value.buildAwsValue()))(
        _.dataAttributes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakera2iruntime.model.StartHumanLoopRequest.ReadOnly =
    zio.aws.sagemakera2iruntime.model.StartHumanLoopRequest
      .wrap(buildAwsValue())
}
object StartHumanLoopRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakera2iruntime.model.StartHumanLoopRequest =
      zio.aws.sagemakera2iruntime.model.StartHumanLoopRequest(
        humanLoopName,
        flowDefinitionArn,
        humanLoopInput.asEditable,
        dataAttributes.map(value => value.asEditable)
      )
    def humanLoopName: HumanLoopName
    def flowDefinitionArn: FlowDefinitionArn
    def humanLoopInput
        : zio.aws.sagemakera2iruntime.model.HumanLoopInput.ReadOnly
    def dataAttributes: Optional[
      zio.aws.sagemakera2iruntime.model.HumanLoopDataAttributes.ReadOnly
    ]
    def getHumanLoopName: ZIO[Any, Nothing, HumanLoopName] =
      ZIO.succeed(humanLoopName)
    def getFlowDefinitionArn: ZIO[Any, Nothing, FlowDefinitionArn] =
      ZIO.succeed(flowDefinitionArn)
    def getHumanLoopInput: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakera2iruntime.model.HumanLoopInput.ReadOnly
    ] = ZIO.succeed(humanLoopInput)
    def getDataAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakera2iruntime.model.HumanLoopDataAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("dataAttributes", dataAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopRequest
  ) extends zio.aws.sagemakera2iruntime.model.StartHumanLoopRequest.ReadOnly {
    override val humanLoopName: HumanLoopName =
      zio.aws.sagemakera2iruntime.model.primitives
        .HumanLoopName(impl.humanLoopName())
    override val flowDefinitionArn: FlowDefinitionArn =
      zio.aws.sagemakera2iruntime.model.primitives
        .FlowDefinitionArn(impl.flowDefinitionArn())
    override val humanLoopInput
        : zio.aws.sagemakera2iruntime.model.HumanLoopInput.ReadOnly =
      zio.aws.sagemakera2iruntime.model.HumanLoopInput
        .wrap(impl.humanLoopInput())
    override val dataAttributes: Optional[
      zio.aws.sagemakera2iruntime.model.HumanLoopDataAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAttributes())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.HumanLoopDataAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.StartHumanLoopRequest
  ): zio.aws.sagemakera2iruntime.model.StartHumanLoopRequest.ReadOnly =
    new Wrapper(impl)
}
