package zio.aws.sagemakera2iruntime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HumanLoopOutput(outputS3Uri: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopOutput = {
    import HumanLoopOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopOutput
      .builder()
      .outputS3Uri(outputS3Uri: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemakera2iruntime.model.HumanLoopOutput.ReadOnly =
    zio.aws.sagemakera2iruntime.model.HumanLoopOutput.wrap(buildAwsValue())
}
object HumanLoopOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakera2iruntime.model.HumanLoopOutput =
      zio.aws.sagemakera2iruntime.model.HumanLoopOutput(outputS3Uri)
    def outputS3Uri: String
    def getOutputS3Uri: ZIO[Any, Nothing, String] = ZIO.succeed(outputS3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopOutput
  ) extends zio.aws.sagemakera2iruntime.model.HumanLoopOutput.ReadOnly {
    override val outputS3Uri: String = impl.outputS3Uri(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopOutput
  ): zio.aws.sagemakera2iruntime.model.HumanLoopOutput.ReadOnly = new Wrapper(
    impl
  )
}
