package zio.aws.sagemakera2iruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakera2iruntime.model.primitives.{
  FlowDefinitionArn,
  FailureReason,
  Timestamp,
  HumanLoopName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class HumanLoopSummary(
    humanLoopName: Option[HumanLoopName] = None,
    humanLoopStatus: Option[zio.aws.sagemakera2iruntime.model.HumanLoopStatus] =
      None,
    creationTime: Option[Timestamp] = None,
    failureReason: Option[FailureReason] = None,
    flowDefinitionArn: Option[FlowDefinitionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary = {
    import HumanLoopSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary
      .builder()
      .optionallyWith(
        humanLoopName.map(value =>
          HumanLoopName.unwrap(value): java.lang.String
        )
      )(_.humanLoopName)
      .optionallyWith(humanLoopStatus.map(value => value.unwrap))(
        _.humanLoopStatus
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        flowDefinitionArn.map(value =>
          FlowDefinitionArn.unwrap(value): java.lang.String
        )
      )(_.flowDefinitionArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly =
    zio.aws.sagemakera2iruntime.model.HumanLoopSummary.wrap(buildAwsValue())
}
object HumanLoopSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakera2iruntime.model.HumanLoopSummary =
      zio.aws.sagemakera2iruntime.model.HumanLoopSummary(
        humanLoopName.map(value => value),
        humanLoopStatus.map(value => value),
        creationTime.map(value => value),
        failureReason.map(value => value),
        flowDefinitionArn.map(value => value)
      )
    def humanLoopName: Option[HumanLoopName]
    def humanLoopStatus
        : Option[zio.aws.sagemakera2iruntime.model.HumanLoopStatus]
    def creationTime: Option[Timestamp]
    def failureReason: Option[FailureReason]
    def flowDefinitionArn: Option[FlowDefinitionArn]
    def getHumanLoopName: ZIO[Any, AwsError, HumanLoopName] =
      AwsError.unwrapOptionField("humanLoopName", humanLoopName)
    def getHumanLoopStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakera2iruntime.model.HumanLoopStatus
    ] = AwsError.unwrapOptionField("humanLoopStatus", humanLoopStatus)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFlowDefinitionArn: ZIO[Any, AwsError, FlowDefinitionArn] =
      AwsError.unwrapOptionField("flowDefinitionArn", flowDefinitionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary
  ) extends zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly {
    override val humanLoopName: Option[HumanLoopName] = scala
      .Option(impl.humanLoopName())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.HumanLoopName(value)
      )
    override val humanLoopStatus
        : Option[zio.aws.sagemakera2iruntime.model.HumanLoopStatus] = scala
      .Option(impl.humanLoopStatus())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.HumanLoopStatus.wrap(value)
      )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.Timestamp(value)
      )
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.FailureReason(value)
      )
    override val flowDefinitionArn: Option[FlowDefinitionArn] = scala
      .Option(impl.flowDefinitionArn())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.FlowDefinitionArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopSummary
  ): zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly = new Wrapper(
    impl
  )
}
