package zio.aws.sagemakera2iruntime
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.sagemakera2iruntime.model.{
  DescribeHumanLoopResponse,
  StartHumanLoopRequest,
  StartHumanLoopResponse,
  ListHumanLoopsRequest,
  DescribeHumanLoopRequest,
  HumanLoopSummary,
  DeleteHumanLoopRequest,
  StopHumanLoopRequest,
  ListHumanLoopsResponse,
  DeleteHumanLoopResponse,
  StopHumanLoopResponse
}
import zio.aws.sagemakera2iruntime.model.StartHumanLoopResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.sagemakera2iruntime.{
  SageMakerA2IRuntimeAsyncClientBuilder,
  SageMakerA2IRuntimeAsyncClient
}
import scala.jdk.CollectionConverters._
trait SageMakerA2IRuntime extends AspectSupport[SageMakerA2IRuntime] {
  val api: SageMakerA2IRuntimeAsyncClient
  def startHumanLoop(
      request: zio.aws.sagemakera2iruntime.model.StartHumanLoopRequest
  ): IO[AwsError, ReadOnly]
  def describeHumanLoop(
      request: zio.aws.sagemakera2iruntime.model.DescribeHumanLoopRequest
  ): IO[
    AwsError,
    zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse.ReadOnly
  ]
  def stopHumanLoop(
      request: zio.aws.sagemakera2iruntime.model.StopHumanLoopRequest
  ): IO[
    AwsError,
    zio.aws.sagemakera2iruntime.model.StopHumanLoopResponse.ReadOnly
  ]
  def deleteHumanLoop(
      request: zio.aws.sagemakera2iruntime.model.DeleteHumanLoopRequest
  ): IO[
    AwsError,
    zio.aws.sagemakera2iruntime.model.DeleteHumanLoopResponse.ReadOnly
  ]
  def listHumanLoops(
      request: zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly
  ]
  def listHumanLoopsPaginated(
      request: zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest
  ): IO[
    AwsError,
    zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse.ReadOnly
  ]
}
object SageMakerA2IRuntime {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SageMakerA2IRuntime] =
    customized(identity)
  def customized(
      customization: SageMakerA2IRuntimeAsyncClientBuilder => SageMakerA2IRuntimeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SageMakerA2IRuntime] = managed(
    customization
  ).toLayer
  def managed(
      customization: SageMakerA2IRuntimeAsyncClientBuilder => SageMakerA2IRuntimeAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, SageMakerA2IRuntime] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = SageMakerA2IRuntimeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        SageMakerA2IRuntimeAsyncClient,
        SageMakerA2IRuntimeAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        SageMakerA2IRuntimeAsyncClient,
        SageMakerA2IRuntimeAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new SageMakerA2IRuntimeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SageMakerA2IRuntimeImpl[R](
      override val api: SageMakerA2IRuntimeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SageMakerA2IRuntime
      with AwsServiceBase[R] {
    override val serviceName: String = "SageMakerA2IRuntime"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SageMakerA2IRuntimeImpl[R1] =
      new SageMakerA2IRuntimeImpl(api, newAspect, r)
    def startHumanLoop(
        request: zio.aws.sagemakera2iruntime.model.StartHumanLoopRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[StartHumanLoopRequest, StartHumanLoopResponse](
        "startHumanLoop",
        api.startHumanLoop
      )(request.buildAwsValue())
        .map(zio.aws.sagemakera2iruntime.model.StartHumanLoopResponse.wrap)
        .provideEnvironment(r)
    def describeHumanLoop(
        request: zio.aws.sagemakera2iruntime.model.DescribeHumanLoopRequest
    ): IO[
      AwsError,
      zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeHumanLoopRequest, DescribeHumanLoopResponse](
        "describeHumanLoop",
        api.describeHumanLoop
      )(request.buildAwsValue())
        .map(zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse.wrap)
        .provideEnvironment(r)
    def stopHumanLoop(
        request: zio.aws.sagemakera2iruntime.model.StopHumanLoopRequest
    ): IO[
      AwsError,
      zio.aws.sagemakera2iruntime.model.StopHumanLoopResponse.ReadOnly
    ] = asyncRequestResponse[StopHumanLoopRequest, StopHumanLoopResponse](
      "stopHumanLoop",
      api.stopHumanLoop
    )(request.buildAwsValue())
      .map(zio.aws.sagemakera2iruntime.model.StopHumanLoopResponse.wrap)
      .provideEnvironment(r)
    def deleteHumanLoop(
        request: zio.aws.sagemakera2iruntime.model.DeleteHumanLoopRequest
    ): IO[
      AwsError,
      zio.aws.sagemakera2iruntime.model.DeleteHumanLoopResponse.ReadOnly
    ] = asyncRequestResponse[DeleteHumanLoopRequest, DeleteHumanLoopResponse](
      "deleteHumanLoop",
      api.deleteHumanLoop
    )(request.buildAwsValue())
      .map(zio.aws.sagemakera2iruntime.model.DeleteHumanLoopResponse.wrap)
      .provideEnvironment(r)
    def listHumanLoops(
        request: zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListHumanLoopsRequest,
      ListHumanLoopsResponse,
      HumanLoopSummary
    ](
      "listHumanLoops",
      api.listHumanLoops,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.humanLoopSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemakera2iruntime.model.HumanLoopSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listHumanLoopsPaginated(
        request: zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest
    ): IO[
      AwsError,
      zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse.ReadOnly
    ] = asyncRequestResponse[ListHumanLoopsRequest, ListHumanLoopsResponse](
      "listHumanLoops",
      api.listHumanLoops
    )(request.buildAwsValue())
      .map(zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse.wrap)
      .provideEnvironment(r)
  }
  def startHumanLoop(
      request: zio.aws.sagemakera2iruntime.model.StartHumanLoopRequest
  ): ZIO[zio.aws.sagemakera2iruntime.SageMakerA2IRuntime, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.startHumanLoop(request))
  def describeHumanLoop(
      request: zio.aws.sagemakera2iruntime.model.DescribeHumanLoopRequest
  ): ZIO[
    zio.aws.sagemakera2iruntime.SageMakerA2IRuntime,
    AwsError,
    zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHumanLoop(request))
  def stopHumanLoop(
      request: zio.aws.sagemakera2iruntime.model.StopHumanLoopRequest
  ): ZIO[
    zio.aws.sagemakera2iruntime.SageMakerA2IRuntime,
    AwsError,
    zio.aws.sagemakera2iruntime.model.StopHumanLoopResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopHumanLoop(request))
  def deleteHumanLoop(
      request: zio.aws.sagemakera2iruntime.model.DeleteHumanLoopRequest
  ): ZIO[
    zio.aws.sagemakera2iruntime.SageMakerA2IRuntime,
    AwsError,
    zio.aws.sagemakera2iruntime.model.DeleteHumanLoopResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteHumanLoop(request))
  def listHumanLoops(
      request: zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest
  ): ZStream[
    zio.aws.sagemakera2iruntime.SageMakerA2IRuntime,
    AwsError,
    zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listHumanLoops(request))
  def listHumanLoopsPaginated(
      request: zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest
  ): ZIO[
    zio.aws.sagemakera2iruntime.SageMakerA2IRuntime,
    AwsError,
    zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHumanLoopsPaginated(request))
}
