package zio.aws.sagemakera2iruntime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.sagemakera2iruntime.model.primitives.{
  MaxResults,
  NextToken,
  FlowDefinitionArn,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListHumanLoopsRequest(
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    flowDefinitionArn: FlowDefinitionArn,
    sortOrder: Optional[zio.aws.sagemakera2iruntime.model.SortOrder] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest = {
    import ListHumanLoopsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .flowDefinitionArn(
        FlowDefinitionArn.unwrap(flowDefinitionArn): java.lang.String
      )
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest.ReadOnly =
    zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest
      .wrap(buildAwsValue())
}
object ListHumanLoopsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest =
      zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        flowDefinitionArn,
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def flowDefinitionArn: FlowDefinitionArn
    def sortOrder: Optional[zio.aws.sagemakera2iruntime.model.SortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getFlowDefinitionArn: ZIO[Any, Nothing, FlowDefinitionArn] =
      ZIO.succeed(flowDefinitionArn)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemakera2iruntime.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest
  ) extends zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest.ReadOnly {
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.Timestamp(value)
      )
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.Timestamp(value)
      )
    override val flowDefinitionArn: FlowDefinitionArn =
      zio.aws.sagemakera2iruntime.model.primitives
        .FlowDefinitionArn(impl.flowDefinitionArn())
    override val sortOrder
        : Optional[zio.aws.sagemakera2iruntime.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemakera2iruntime.model.SortOrder.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.sagemakera2iruntime.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.ListHumanLoopsRequest
  ): zio.aws.sagemakera2iruntime.model.ListHumanLoopsRequest.ReadOnly =
    new Wrapper(impl)
}
