package zio.aws.sagemakera2iruntime
import zio.mock.{Proxy, Mock}
import zio.aws.sagemakera2iruntime.model.StartHumanLoopResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.sagemakera2iruntime.model.{
  StartHumanLoopRequest,
  ListHumanLoopsRequest,
  DescribeHumanLoopRequest,
  DeleteHumanLoopRequest,
  StopHumanLoopRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.sagemakera2iruntime.SageMakerA2IRuntimeAsyncClient
object SageMakerA2IRuntimeMock extends Mock[SageMakerA2IRuntime] {
  object StartHumanLoop
      extends Effect[StartHumanLoopRequest, AwsError, ReadOnly]
  object DescribeHumanLoop
      extends Effect[
        DescribeHumanLoopRequest,
        AwsError,
        zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse.ReadOnly
      ]
  object StopHumanLoop
      extends Effect[
        StopHumanLoopRequest,
        AwsError,
        zio.aws.sagemakera2iruntime.model.StopHumanLoopResponse.ReadOnly
      ]
  object DeleteHumanLoop
      extends Effect[
        DeleteHumanLoopRequest,
        AwsError,
        zio.aws.sagemakera2iruntime.model.DeleteHumanLoopResponse.ReadOnly
      ]
  object ListHumanLoops
      extends Stream[
        ListHumanLoopsRequest,
        AwsError,
        zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly
      ]
  object ListHumanLoopsPaginated
      extends Effect[
        ListHumanLoopsRequest,
        AwsError,
        zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SageMakerA2IRuntime] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new SageMakerA2IRuntime {
          val api: SageMakerA2IRuntimeAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : SageMakerA2IRuntime = this
          def startHumanLoop(
              request: StartHumanLoopRequest
          ): IO[AwsError, ReadOnly] = proxy(StartHumanLoop, request)
          def describeHumanLoop(request: DescribeHumanLoopRequest): IO[
            AwsError,
            zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse.ReadOnly
          ] = proxy(DescribeHumanLoop, request)
          def stopHumanLoop(request: StopHumanLoopRequest): IO[
            AwsError,
            zio.aws.sagemakera2iruntime.model.StopHumanLoopResponse.ReadOnly
          ] = proxy(StopHumanLoop, request)
          def deleteHumanLoop(request: DeleteHumanLoopRequest): IO[
            AwsError,
            zio.aws.sagemakera2iruntime.model.DeleteHumanLoopResponse.ReadOnly
          ] = proxy(DeleteHumanLoop, request)
          def listHumanLoops(request: ListHumanLoopsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.sagemakera2iruntime.model.HumanLoopSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListHumanLoops, request))
          def listHumanLoopsPaginated(request: ListHumanLoopsRequest): IO[
            AwsError,
            zio.aws.sagemakera2iruntime.model.ListHumanLoopsResponse.ReadOnly
          ] = proxy(ListHumanLoopsPaginated, request)
        }
      }
    }
    .toLayer
}
