package zio.aws.sagemakera2iruntime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HumanLoopDataAttributes(
    contentClassifiers: Iterable[
      zio.aws.sagemakera2iruntime.model.ContentClassifier
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopDataAttributes = {
    import HumanLoopDataAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopDataAttributes
      .builder()
      .contentClassifiersWithStrings(contentClassifiers.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakera2iruntime.model.HumanLoopDataAttributes.ReadOnly =
    zio.aws.sagemakera2iruntime.model.HumanLoopDataAttributes
      .wrap(buildAwsValue())
}
object HumanLoopDataAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopDataAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakera2iruntime.model.HumanLoopDataAttributes =
      zio.aws.sagemakera2iruntime.model
        .HumanLoopDataAttributes(contentClassifiers)
    def contentClassifiers
        : List[zio.aws.sagemakera2iruntime.model.ContentClassifier]
    def getContentClassifiers: ZIO[Any, Nothing, List[
      zio.aws.sagemakera2iruntime.model.ContentClassifier
    ]] = ZIO.succeed(contentClassifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopDataAttributes
  ) extends zio.aws.sagemakera2iruntime.model.HumanLoopDataAttributes.ReadOnly {
    override val contentClassifiers
        : List[zio.aws.sagemakera2iruntime.model.ContentClassifier] = impl
      .contentClassifiers()
      .asScala
      .map { item =>
        zio.aws.sagemakera2iruntime.model.ContentClassifier.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopDataAttributes
  ): zio.aws.sagemakera2iruntime.model.HumanLoopDataAttributes.ReadOnly =
    new Wrapper(impl)
}
