package zio.aws.sagemakera2iruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemakera2iruntime.model.primitives.{
  FlowDefinitionArn,
  HumanLoopArn,
  HumanLoopName,
  Timestamp
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeHumanLoopResponse(
    creationTime: Timestamp,
    failureReason: Option[String] = None,
    failureCode: Option[String] = None,
    humanLoopStatus: zio.aws.sagemakera2iruntime.model.HumanLoopStatus,
    humanLoopName: HumanLoopName,
    humanLoopArn: HumanLoopArn,
    flowDefinitionArn: FlowDefinitionArn,
    humanLoopOutput: Option[zio.aws.sagemakera2iruntime.model.HumanLoopOutput] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopResponse = {
    import DescribeHumanLoopResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopResponse
      .builder()
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .humanLoopStatus(humanLoopStatus.unwrap)
      .humanLoopName(HumanLoopName.unwrap(humanLoopName): java.lang.String)
      .humanLoopArn(HumanLoopArn.unwrap(humanLoopArn): java.lang.String)
      .flowDefinitionArn(
        FlowDefinitionArn.unwrap(flowDefinitionArn): java.lang.String
      )
      .optionallyWith(humanLoopOutput.map(value => value.buildAwsValue()))(
        _.humanLoopOutput
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse.ReadOnly =
    zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse
      .wrap(buildAwsValue())
}
object DescribeHumanLoopResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse =
      zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse(
        creationTime,
        failureReason.map(value => value),
        failureCode.map(value => value),
        humanLoopStatus,
        humanLoopName,
        humanLoopArn,
        flowDefinitionArn,
        humanLoopOutput.map(value => value.asEditable)
      )
    def creationTime: Timestamp
    def failureReason: Option[String]
    def failureCode: Option[String]
    def humanLoopStatus: zio.aws.sagemakera2iruntime.model.HumanLoopStatus
    def humanLoopName: HumanLoopName
    def humanLoopArn: HumanLoopArn
    def flowDefinitionArn: FlowDefinitionArn
    def humanLoopOutput
        : Option[zio.aws.sagemakera2iruntime.model.HumanLoopOutput.ReadOnly]
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getFailureReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFailureCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getHumanLoopStatus
        : ZIO[Any, Nothing, zio.aws.sagemakera2iruntime.model.HumanLoopStatus] =
      ZIO.succeed(humanLoopStatus)
    def getHumanLoopName: ZIO[Any, Nothing, HumanLoopName] =
      ZIO.succeed(humanLoopName)
    def getHumanLoopArn: ZIO[Any, Nothing, HumanLoopArn] =
      ZIO.succeed(humanLoopArn)
    def getFlowDefinitionArn: ZIO[Any, Nothing, FlowDefinitionArn] =
      ZIO.succeed(flowDefinitionArn)
    def getHumanLoopOutput: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakera2iruntime.model.HumanLoopOutput.ReadOnly
    ] = AwsError.unwrapOptionField("humanLoopOutput", humanLoopOutput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopResponse
  ) extends zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse.ReadOnly {
    override val creationTime: Timestamp =
      zio.aws.sagemakera2iruntime.model.primitives
        .Timestamp(impl.creationTime())
    override val failureReason: Option[String] =
      scala.Option(impl.failureReason()).map(value => value: String)
    override val failureCode: Option[String] =
      scala.Option(impl.failureCode()).map(value => value: String)
    override val humanLoopStatus
        : zio.aws.sagemakera2iruntime.model.HumanLoopStatus =
      zio.aws.sagemakera2iruntime.model.HumanLoopStatus
        .wrap(impl.humanLoopStatus())
    override val humanLoopName: HumanLoopName =
      zio.aws.sagemakera2iruntime.model.primitives
        .HumanLoopName(impl.humanLoopName())
    override val humanLoopArn: HumanLoopArn =
      zio.aws.sagemakera2iruntime.model.primitives
        .HumanLoopArn(impl.humanLoopArn())
    override val flowDefinitionArn: FlowDefinitionArn =
      zio.aws.sagemakera2iruntime.model.primitives
        .FlowDefinitionArn(impl.flowDefinitionArn())
    override val humanLoopOutput
        : Option[zio.aws.sagemakera2iruntime.model.HumanLoopOutput.ReadOnly] =
      scala
        .Option(impl.humanLoopOutput())
        .map(value =>
          zio.aws.sagemakera2iruntime.model.HumanLoopOutput.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakera2iruntime.model.DescribeHumanLoopResponse
  ): zio.aws.sagemakera2iruntime.model.DescribeHumanLoopResponse.ReadOnly =
    new Wrapper(impl)
}
