package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait TargetPlatformAccelerator {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator
}
object TargetPlatformAccelerator {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator
  ): zio.aws.sagemaker.model.TargetPlatformAccelerator = value match {
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator.INTEL_GRAPHICS =>
      val r = INTEL_GRAPHICS
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator.MALI =>
      val r = MALI
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator.NVIDIA =>
      val r = NVIDIA
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator.NNA =>
      val r = NNA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TargetPlatformAccelerator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator.UNKNOWN_TO_SDK_VERSION
  }
  case object INTEL_GRAPHICS
      extends zio.aws.sagemaker.model.TargetPlatformAccelerator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator.INTEL_GRAPHICS
  }
  case object MALI extends zio.aws.sagemaker.model.TargetPlatformAccelerator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator.MALI
  }
  case object NVIDIA extends zio.aws.sagemaker.model.TargetPlatformAccelerator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator.NVIDIA
  }
  case object NNA extends zio.aws.sagemaker.model.TargetPlatformAccelerator {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator =
      software.amazon.awssdk.services.sagemaker.model.TargetPlatformAccelerator.NNA
  }
}
