package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.String256
import scala.jdk.CollectionConverters.*
final case class SelectedStep(stepName: String256) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SelectedStep = {
    import SelectedStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SelectedStep
      .builder()
      .stepName(String256.unwrap(stepName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SelectedStep.ReadOnly =
    zio.aws.sagemaker.model.SelectedStep.wrap(buildAwsValue())
}
object SelectedStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SelectedStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SelectedStep =
      zio.aws.sagemaker.model.SelectedStep(stepName)
    def stepName: String256
    def getStepName: ZIO[Any, Nothing, String256] = ZIO.succeed(stepName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SelectedStep
  ) extends zio.aws.sagemaker.model.SelectedStep.ReadOnly {
    override val stepName: String256 =
      zio.aws.sagemaker.model.primitives.String256(impl.stepName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SelectedStep
  ): zio.aws.sagemaker.model.SelectedStep.ReadOnly = new Wrapper(impl)
}
