package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{KmsKeyId, DestinationS3Uri}
import scala.jdk.CollectionConverters.*
final case class InferenceExperimentDataStorageConfig(
    destination: DestinationS3Uri,
    kmsKey: Optional[KmsKeyId] = Optional.Absent,
    contentType: Optional[zio.aws.sagemaker.model.CaptureContentTypeHeader] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InferenceExperimentDataStorageConfig = {
    import InferenceExperimentDataStorageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InferenceExperimentDataStorageConfig
      .builder()
      .destination(DestinationS3Uri.unwrap(destination): java.lang.String)
      .optionallyWith(
        kmsKey.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(contentType.map(value => value.buildAwsValue()))(
        _.contentType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly =
    zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig
      .wrap(buildAwsValue())
}
object InferenceExperimentDataStorageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InferenceExperimentDataStorageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig =
      zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig(
        destination,
        kmsKey.map(value => value),
        contentType.map(value => value.asEditable)
      )
    def destination: DestinationS3Uri
    def kmsKey: Optional[KmsKeyId]
    def contentType
        : Optional[zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly]
    def getDestination: ZIO[Any, Nothing, DestinationS3Uri] =
      ZIO.succeed(destination)
    def getKmsKey: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getContentType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly
    ] = AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentDataStorageConfig
  ) extends zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly {
    override val destination: DestinationS3Uri =
      zio.aws.sagemaker.model.primitives.DestinationS3Uri(impl.destination())
    override val kmsKey: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val contentType
        : Optional[zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentType())
        .map(value =>
          zio.aws.sagemaker.model.CaptureContentTypeHeader.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceExperimentDataStorageConfig
  ): zio.aws.sagemaker.model.InferenceExperimentDataStorageConfig.ReadOnly =
    new Wrapper(impl)
}
