package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  EdgeDeploymentPlanArn,
  DeviceArn,
  DeviceName,
  DeviceDescription,
  Timestamp,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeviceDeploymentSummary(
    edgeDeploymentPlanArn: EdgeDeploymentPlanArn,
    edgeDeploymentPlanName: EntityName,
    stageName: EntityName,
    deployedStageName: Optional[EntityName] = Optional.Absent,
    deviceFleetName: Optional[EntityName] = Optional.Absent,
    deviceName: DeviceName,
    deviceArn: DeviceArn,
    deviceDeploymentStatus: Optional[
      zio.aws.sagemaker.model.DeviceDeploymentStatus
    ] = Optional.Absent,
    deviceDeploymentStatusMessage: Optional[String] = Optional.Absent,
    description: Optional[DeviceDescription] = Optional.Absent,
    deploymentStartTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentSummary = {
    import DeviceDeploymentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentSummary
      .builder()
      .edgeDeploymentPlanArn(
        EdgeDeploymentPlanArn.unwrap(edgeDeploymentPlanArn): java.lang.String
      )
      .edgeDeploymentPlanName(
        EntityName.unwrap(edgeDeploymentPlanName): java.lang.String
      )
      .stageName(EntityName.unwrap(stageName): java.lang.String)
      .optionallyWith(
        deployedStageName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.deployedStageName)
      .optionallyWith(
        deviceFleetName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.deviceFleetName)
      .deviceName(DeviceName.unwrap(deviceName): java.lang.String)
      .deviceArn(DeviceArn.unwrap(deviceArn): java.lang.String)
      .optionallyWith(deviceDeploymentStatus.map(value => value.unwrap))(
        _.deviceDeploymentStatus
      )
      .optionallyWith(
        deviceDeploymentStatusMessage.map(value => value: java.lang.String)
      )(_.deviceDeploymentStatusMessage)
      .optionallyWith(
        description.map(value =>
          DeviceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        deploymentStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.deploymentStartTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeviceDeploymentSummary.ReadOnly =
    zio.aws.sagemaker.model.DeviceDeploymentSummary.wrap(buildAwsValue())
}
object DeviceDeploymentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeviceDeploymentSummary =
      zio.aws.sagemaker.model.DeviceDeploymentSummary(
        edgeDeploymentPlanArn,
        edgeDeploymentPlanName,
        stageName,
        deployedStageName.map(value => value),
        deviceFleetName.map(value => value),
        deviceName,
        deviceArn,
        deviceDeploymentStatus.map(value => value),
        deviceDeploymentStatusMessage.map(value => value),
        description.map(value => value),
        deploymentStartTime.map(value => value)
      )
    def edgeDeploymentPlanArn: EdgeDeploymentPlanArn
    def edgeDeploymentPlanName: EntityName
    def stageName: EntityName
    def deployedStageName: Optional[EntityName]
    def deviceFleetName: Optional[EntityName]
    def deviceName: DeviceName
    def deviceArn: DeviceArn
    def deviceDeploymentStatus
        : Optional[zio.aws.sagemaker.model.DeviceDeploymentStatus]
    def deviceDeploymentStatusMessage: Optional[String]
    def description: Optional[DeviceDescription]
    def deploymentStartTime: Optional[Timestamp]
    def getEdgeDeploymentPlanArn: ZIO[Any, Nothing, EdgeDeploymentPlanArn] =
      ZIO.succeed(edgeDeploymentPlanArn)
    def getEdgeDeploymentPlanName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgeDeploymentPlanName)
    def getStageName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(stageName)
    def getDeployedStageName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("deployedStageName", deployedStageName)
    def getDeviceFleetName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("deviceFleetName", deviceFleetName)
    def getDeviceName: ZIO[Any, Nothing, DeviceName] = ZIO.succeed(deviceName)
    def getDeviceArn: ZIO[Any, Nothing, DeviceArn] = ZIO.succeed(deviceArn)
    def getDeviceDeploymentStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DeviceDeploymentStatus] =
      AwsError.unwrapOptionField(
        "deviceDeploymentStatus",
        deviceDeploymentStatus
      )
    def getDeviceDeploymentStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "deviceDeploymentStatusMessage",
        deviceDeploymentStatusMessage
      )
    def getDescription: ZIO[Any, AwsError, DeviceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDeploymentStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deploymentStartTime", deploymentStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentSummary
  ) extends zio.aws.sagemaker.model.DeviceDeploymentSummary.ReadOnly {
    override val edgeDeploymentPlanArn: EdgeDeploymentPlanArn =
      zio.aws.sagemaker.model.primitives
        .EdgeDeploymentPlanArn(impl.edgeDeploymentPlanArn())
    override val edgeDeploymentPlanName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.edgeDeploymentPlanName())
    override val stageName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.stageName())
    override val deployedStageName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.deployedStageName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val deviceFleetName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceFleetName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val deviceName: DeviceName =
      zio.aws.sagemaker.model.primitives.DeviceName(impl.deviceName())
    override val deviceArn: DeviceArn =
      zio.aws.sagemaker.model.primitives.DeviceArn(impl.deviceArn())
    override val deviceDeploymentStatus
        : Optional[zio.aws.sagemaker.model.DeviceDeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceDeploymentStatus())
        .map(value =>
          zio.aws.sagemaker.model.DeviceDeploymentStatus.wrap(value)
        )
    override val deviceDeploymentStatusMessage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceDeploymentStatusMessage())
        .map(value => value: String)
    override val description: Optional[DeviceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DeviceDescription(value)
        )
    override val deploymentStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStartTime())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentSummary
  ): zio.aws.sagemaker.model.DeviceDeploymentSummary.ReadOnly = new Wrapper(
    impl
  )
}
