package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.DomainId
import scala.jdk.CollectionConverters.*
final case class DescribeDomainRequest(domainId: DomainId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest = {
    import DescribeDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeDomainRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeDomainRequest.wrap(buildAwsValue())
}
object DescribeDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeDomainRequest =
      zio.aws.sagemaker.model.DescribeDomainRequest(domainId)
    def domainId: DomainId
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest
  ) extends zio.aws.sagemaker.model.DescribeDomainRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest
  ): zio.aws.sagemaker.model.DescribeDomainRequest.ReadOnly = new Wrapper(impl)
}
